/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.infrastructure.serviceImpl.insurance;

import com.eabrokers.logic.data.DataFileDocumentSign;
import com.eabrokers.logic.dto.InsuredDocumentDTO;
import com.eabrokers.logic.entity.insurance.TDocumentInsurance;
import com.eabrokers.logic.entity.insurance.TPrimaType;
import com.eabrokers.logic.infrastructure.service.insurance.DocumentFileService;
import com.eabrokers.logic.infrastructure.service.insurance.DocumentInsuranceService;
import com.eabrokers.logic.infrastructure.service.insurance.FileService;
import com.eabrokers.logic.infrastructure.service.insurance.PrimaTypeService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DocumentFileServiceImpl
implements DocumentFileService {
    @Autowired
    private PrimaTypeService primaTypeService;
    @Autowired
    private DocumentInsuranceService documentInsuranceService;
    @Autowired
    private FileService fileService;

    public DataFileDocumentSign findDocumentsSign(InsuredDocumentDTO insuredDocumentDTO) {
        if (insuredDocumentDTO == null) {
            return null;
        }
        Long primaId = insuredDocumentDTO.getPrimaId();
        boolean partnerActive = insuredDocumentDTO.isInsuredPartnerActive();
        Long accountType = insuredDocumentDTO.getAccountTypeId();
        Optional primaTypeOptional = this.primaTypeService.findById(primaId);
        if (primaTypeOptional.isEmpty()) {
            return null;
        }
        TPrimaType primaType = (TPrimaType)primaTypeOptional.get();
        Boolean unemploymentActive = primaType.getInclusiveInsurance().getUnemploymentActive();
        Long frequencyId = primaType.getPrimaFrequency();
        List documentsAuthorization = this.documentInsuranceService.findDocumentsByAuthorization(Boolean.valueOf(partnerActive), accountType);
        List documentsCertificate = this.documentInsuranceService.findDocumentsByCertificate(Boolean.valueOf(partnerActive), frequencyId, unemploymentActive);
        if (documentsAuthorization.size() != 1 || documentsCertificate.size() != 1) {
            return null;
        }
        ArrayList listDocumentInsurance = new ArrayList();
        listDocumentInsurance.addAll(documentsAuthorization);
        listDocumentInsurance.addAll(documentsCertificate);
        TDocumentInsurance documentInsuranceAuthorization = (TDocumentInsurance)documentsAuthorization.get(0);
        TDocumentInsurance documentInsuranceCertificate = (TDocumentInsurance)documentsCertificate.get(0);
        Optional fileAuthorization = this.getFileContent(documentInsuranceAuthorization.getPdfFileId());
        Optional fileCertificate = this.getFileContent(documentInsuranceCertificate.getPdfFileId());
        if (fileAuthorization.isEmpty() || fileCertificate.isEmpty()) {
            return null;
        }
        return new DataFileDocumentSign(documentInsuranceAuthorization, documentInsuranceCertificate, (byte[])fileAuthorization.get(), (byte[])fileCertificate.get(), frequencyId);
    }

    private Optional<byte[]> getFileContent(String fileId) {
        return this.fileService.getFileById(fileId).map(file -> file.getFile());
    }
}

