/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.infrastructure.serviceImpl.insurance;

import com.eabrokers.common.transactions.TransactionCustom;
import com.eabrokers.logic.data.DocumentValue;
import com.eabrokers.logic.dto.DocumentsSignDTO;
import com.eabrokers.logic.entity.enums.DocumentSignStatus;
import com.eabrokers.logic.entity.insurance.TBiometricTransaction;
import com.eabrokers.logic.entity.insurance.TDocumentTransaction;
import com.eabrokers.logic.entity.insurance.TDocumentTransactionDetail;
import com.eabrokers.logic.entity.insurance.TFileDocument;
import com.eabrokers.logic.infrastructure.service.insurance.BiometricDocumentService;
import com.eabrokers.logic.infrastructure.service.insurance.BiometricTransactionService;
import com.eabrokers.logic.infrastructure.service.insurance.DocumentTransactionDetailService;
import com.eabrokers.logic.infrastructure.service.insurance.DocumentTransactionService;
import com.eabrokers.logic.infrastructure.service.insurance.FileDocumentService;
import com.eabrokers.logic.infrastructure.service.insurance.LinkService;
import com.eabrokers.logic.infrastructure.service.insurance.NotifySignService;
import com.eabrokers.logic.request.CallbackDocumentRequest;
import com.eabrokers.logic.response.ResponseResult;
import com.eabrokers.logic.response.StampCustomResponse;
import com.eabrokers.utils.FileUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BiometricDocumentServiceImpl
implements BiometricDocumentService {
    private static final Logger log = LoggerFactory.getLogger(BiometricDocumentServiceImpl.class);
    private final FileDocumentService fileDocumentService;
    private final BiometricTransactionService biometricTransactionService;
    private final DocumentTransactionService documentTransactionService;
    private final DocumentTransactionDetailService documentTransactionDetailService;
    private final NotifySignService notifySignService;
    private final LinkService linkService;

    @Transactional
    public ResponseEntity<ResponseResult<?>> callbackDocuments(CallbackDocumentRequest documentRequest) {
        this.processCallback(documentRequest);
        return TransactionCustom.ok();
    }

    @Transactional
    public void callbackDocumentsMap(Map<String, Object> callback) {
        CallbackDocumentRequest documentRequest = this.convertCallbackDocumentRequest(callback);
        if (documentRequest == null) {
            return;
        }
        this.processCallback(documentRequest);
    }

    public ResponseEntity<ResponseResult<?>> listDocumentsSign(DocumentsSignDTO documentsSignDTO) {
        int maxRetries = 2;
        int attempts = 0;
        ArrayList<DocumentValue> listDocumentValue = new ArrayList<DocumentValue>();
        while (attempts < maxRetries) {
            ++attempts;
            List dataListDocuments = this.documentTransactionDetailService.findByDocumentTransactionId(documentsSignDTO.getIdDocumentTransaction());
            listDocumentValue.clear();
            for (TDocumentTransactionDetail detail : dataListDocuments) {
                DocumentValue documentTemp = this.createDocumentValue(detail.getDocumentName(), detail.getFileDocumentId(), "DOCUMENT " + detail.getDocumentName());
                if (detail.getDocumentDetailStatus() == DocumentSignStatus.STAMPED) continue;
                listDocumentValue.add(documentTemp);
            }
            if (!listDocumentValue.isEmpty()) break;
            if (attempts >= maxRetries) continue;
            try {
                Thread.sleep(1000L);
                log.info("Intento " + attempts);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Error al pausar el hilo", e);
            }
        }
        StampCustomResponse dataStampCustomResponse = new StampCustomResponse(documentsSignDTO.getIdDocumentTransaction(), listDocumentValue);
        return TransactionCustom.ok((Object)dataStampCustomResponse);
    }

    private DocumentValue createDocumentValue(String name, String fileId, String description) {
        DocumentValue documentValue = new DocumentValue();
        documentValue.setName(name);
        documentValue.setDescription(description);
        documentValue.setUrlDocument(this.linkService.linkFilesDocs(fileId));
        return documentValue;
    }

    private void processCallback(CallbackDocumentRequest documentRequest) {
        if (documentRequest.getStatus() != 200) {
            return;
        }
        CallbackDocumentRequest.DataRequest dataRequest = documentRequest.getData();
        if (dataRequest == null || dataRequest.getTipo() == null) {
            return;
        }
        if (!"DOCUMENTO".equals(dataRequest.getTipo())) {
            return;
        }
        String codeBiometric = documentRequest.getCodigo();
        String nameDocument = dataRequest.getNombre();
        String fileBase64 = dataRequest.getArchivo();
        Optional biometricFind = this.biometricTransactionService.findByCodeBiometric(codeBiometric);
        if (biometricFind.isEmpty()) {
            return;
        }
        Long transactionId = ((TBiometricTransaction)biometricFind.get()).getDocumentTransactionId();
        Optional transactionTemp = this.documentTransactionService.findById(transactionId);
        if (transactionTemp.isEmpty()) {
            return;
        }
        TDocumentTransaction transactionFind = (TDocumentTransaction)transactionTemp.get();
        if (transactionFind.getDocumentStatus() == TDocumentTransaction.DocumentStatus.SIGNED_USER) {
            return;
        }
        Optional documentTransactionDetail = this.documentTransactionDetailService.findByDocumentNameAndDocumentTransactionId(nameDocument, ((TBiometricTransaction)biometricFind.get()).getDocumentTransactionId());
        if (documentTransactionDetail.isEmpty()) {
            return;
        }
        String fileDocumentId = ((TDocumentTransactionDetail)documentTransactionDetail.get()).getFileDocumentId();
        Optional fileDocumentTemp = this.fileDocumentService.getFileById(fileDocumentId);
        if (!fileDocumentTemp.isPresent()) {
            return;
        }
        boolean isUpdateDocuments = this.updateDetailDocuments((TFileDocument)fileDocumentTemp.get(), fileBase64, (TDocumentTransactionDetail)documentTransactionDetail.get());
        log.info("Document Transaction: " + transactionId + " Status Update: " + isUpdateDocuments);
        int resultCount = this.countDocuments(transactionId);
        if (transactionFind.getTotalDocument() == resultCount) {
            log.info("Transaction Complete:" + transactionId);
            transactionFind.setDocumentStatus(TDocumentTransaction.DocumentStatus.SIGNED_USER);
            this.documentTransactionService.save(transactionFind);
            try {
                log.info("Send Notification.....");
                this.notifySignService.notifyDocumentStatus(transactionFind, TDocumentTransaction.DocumentStatus.SIGNED_USER, null);
            }
            catch (Exception e) {
                log.error("Error al notificar el estado del documento: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private boolean updateDetailDocuments(TFileDocument fileDocumentTemp, String fileBase64, TDocumentTransactionDetail documentTransactionDetail) {
        try {
            TFileDocument fileDocumentFind = fileDocumentTemp;
            fileDocumentFind.setFileStatus(TFileDocument.FileStatus.ACTIVE);
            fileDocumentFind.setFile(FileUtil.base64ToByte((String)fileBase64));
            this.fileDocumentService.save(fileDocumentFind);
            TDocumentTransactionDetail detail = documentTransactionDetail;
            detail.setDocumentDetailStatus(DocumentSignStatus.SIGNED_USER);
            this.documentTransactionDetailService.save(detail);
            return true;
        }
        catch (Exception e) {
            log.error("Error update documents {}", (Throwable)e);
            return false;
        }
    }

    private int countDocuments(Long transactionId) {
        List listDetailTransaction = this.documentTransactionDetailService.findByDocumentTransactionId(transactionId);
        AtomicInteger countDocuments = new AtomicInteger(0);
        listDetailTransaction.forEach(item -> {
            if (item.getDocumentDetailStatus() == DocumentSignStatus.SIGNED_USER) {
                countDocuments.incrementAndGet();
            }
        });
        return countDocuments.get();
    }

    private CallbackDocumentRequest convertCallbackDocumentRequest(Map<String, Object> callbackMap) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            CallbackDocumentRequest callbackDocumentRequest = (CallbackDocumentRequest)objectMapper.convertValue(callbackMap, CallbackDocumentRequest.class);
            return callbackDocumentRequest;
        }
        catch (Exception e) {
            log.error("Error  convertCallbackDocumentRequest {}", (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    public BiometricDocumentServiceImpl(FileDocumentService fileDocumentService, BiometricTransactionService biometricTransactionService, DocumentTransactionService documentTransactionService, DocumentTransactionDetailService documentTransactionDetailService, NotifySignService notifySignService, LinkService linkService) {
        this.fileDocumentService = fileDocumentService;
        this.biometricTransactionService = biometricTransactionService;
        this.documentTransactionService = documentTransactionService;
        this.documentTransactionDetailService = documentTransactionDetailService;
        this.notifySignService = notifySignService;
        this.linkService = linkService;
    }
}

