/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.infrastructure.serviceImpl.biometria;

import com.eabrokers.logic.data.ResponseBiometriaUanataca;
import com.eabrokers.logic.data.ResponseFirmaUanataca;
import com.eabrokers.logic.entity.TSolicitud;
import com.eabrokers.logic.entity.biometria.TCallbackBiometria;
import com.eabrokers.logic.entity.firma.TCallbackFirma;
import com.eabrokers.logic.infrastructure.service.biometria.CanalService;
import com.eabrokers.logic.infrastructure.service.biometria.DataBaseService;
import com.eabrokers.logic.infrastructure.service.biometria.OrigenService;
import com.eabrokers.logic.infrastructure.service.biometria.SolicitudFirmaService;
import com.eabrokers.logic.infrastructure.service.biometria.UanatacaService;
import com.eabrokers.logic.repository.biometria.SolicitudDAO;
import com.eabrokers.logic.restTemplate.service.UanatacaServiceAPI;
import com.eabrokers.utils.ApiResponse;
import ec.tws2.crypto.run.CryptoMain;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class UanatacaServiceImpl
implements UanatacaService {
    private static final Logger log = LoggerFactory.getLogger(UanatacaServiceImpl.class);
    private final UanatacaServiceAPI uanatacaApi;
    private final SolicitudFirmaService solicitudFirmaService;
    private final DataBaseService baseService;
    private final SolicitudDAO solicitudDAO;
    private final CryptoMain cryptoService;
    private final Environment env;
    private final CanalService canalService;
    private final OrigenService origenService;

    public ResponseEntity<?> solicitarBiometria(String identificacion, String callback, String codigoInterno, String motivo, String origen, String canal) {
        log.info("Solicitando la biometria");
        if (codigoInterno == null) {
            codigoInterno = UUID.randomUUID().toString();
        }
        canal = this.canalService.validarCanal(canal);
        origen = this.origenService.validarOrigen(origen);
        String tipoSolicitud = this.env.getProperty("tws.tipotrans.bio");
        String schemeBiometria = this.env.getProperty("tws.schema.biometria");
        String codigoInternoTws = UUID.randomUUID().toString();
        String buildedCodigoInterno = schemeBiometria.replace("{cliente}", identificacion).replace("{canal}", canal).replace("{codigoInternoTws}", codigoInternoTws).replace("{codigoInterno}", codigoInterno).replace("{origen}", origen);
        String tokenEncripted = this.baseService.getTokenFromJti();
        String tokenUA = this.cryptoService.decrypt(tokenEncripted);
        String twsCallback = this.env.getProperty("tws.callback.biometria");
        ResponseBiometriaUanataca response = this.uanatacaApi.getBiometriaUanataca(identificacion, twsCallback, buildedCodigoInterno, motivo, tokenUA);
        String codigoTransaccion = response.getStatus() == 200 ? response.getData().getCodigo() : null;
        String status = codigoTransaccion != null ? "OK" : "ERROR: " + String.valueOf(response.getMessages());
        TSolicitud solicitud = new TSolicitud(this.cryptoService.encriptar(callback), this.cryptoService.encriptar(twsCallback), codigoTransaccion, codigoInterno, buildedCodigoInterno, tipoSolicitud, status, tokenEncripted);
        this.solicitudDAO.save((Object)solicitud);
        log.info("informacion del proceso guardada correctamente");
        if (response.getStatus() == 200) {
            return new ResponseEntity((Object)ApiResponse.ok((int)response.getStatus(), (Object)response.getData()), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((Object)ApiResponse.error((int)response.getStatus(), (Map)response.getMessages()), (HttpStatusCode)HttpStatus.valueOf((int)response.getStatus()));
    }

    public ResponseEntity<?> solicitarBiometriaFirmaFlujoUnico(String codigoCliente, String identificacion, String nombres, String apellidoPaterno, String apellidoMaterno, String email, String celular, String domicilio, String ciudad, String documentos, String motivo, String origen, String callback, String canal) {
        log.info("Solicitando la biometria y firma en un solo paso");
        if (codigoCliente == null) {
            codigoCliente = UUID.randomUUID().toString();
        }
        canal = this.canalService.validarCanal(canal);
        origen = this.origenService.validarOrigen(origen);
        String tipoSolicitud = this.env.getProperty("tws.tipotrans.bio-fir");
        String schemeBiometria = this.env.getProperty("tws.schema.biometria-firma");
        String codigoInternoTws = UUID.randomUUID().toString();
        String buildedCodigoInterno = schemeBiometria.replace("{cliente}", identificacion).replace("{canal}", canal).replace("{codigoInternoTws}", codigoInternoTws).replace("{codigoInterno}", codigoCliente).replace("{origen}", origen);
        String tokenEncripted = this.baseService.getTokenFromJti();
        String tokenUA = this.cryptoService.decrypt(tokenEncripted);
        String twsCallback = this.env.getProperty("tws.callback.biometria-firma");
        ResponseBiometriaUanataca response = this.uanatacaApi.getBiometriaFirmaUanataca(codigoCliente, identificacion, nombres, apellidoPaterno, apellidoMaterno, email, celular, domicilio, ciudad, documentos, motivo, twsCallback, tokenUA);
        String codigoTransaccion = response.getStatus() == 200 ? response.getData().getCodigo() : null;
        String status = codigoTransaccion != null ? "OK" : "ERROR: " + String.valueOf(response.getMessages());
        TSolicitud solicitud = new TSolicitud(this.cryptoService.encriptar(callback), this.cryptoService.encriptar(twsCallback), codigoTransaccion, codigoCliente, buildedCodigoInterno, tipoSolicitud, status, tokenEncripted);
        this.solicitudDAO.save((Object)solicitud);
        log.info("informacion del proceso guardada correctamente");
        if (response.getStatus() == 200) {
            this.solicitudFirmaService.saveSolicitudFima(codigoTransaccion, codigoCliente, identificacion, nombres, apellidoPaterno, apellidoMaterno, email, celular, domicilio, ciudad, origen, callback);
            return new ResponseEntity((Object)ApiResponse.ok((int)response.getStatus(), (Object)response.getData()), (HttpStatusCode)HttpStatus.OK);
        }
        log.error("ERROR AL SOLICITAR LA BIOMETRIA Y FIRMA EN UN SOLO PASO {} ", (Object)response);
        return new ResponseEntity((Object)ApiResponse.error((int)response.getStatus(), (Map)response.getMessages()), (HttpStatusCode)HttpStatus.valueOf((int)response.getStatus()));
    }

    public ResponseEntity<?> solicitarFirma(String codigoBiometrico, String codigoCliente, String identificacion, String nombres, String apellidoPaterno, String apellidoMaterno, String email, String celular, String domicilio, String ciudad, String documentos, String origen, String callback, String canal) {
        log.info("Solicitando la FIRMA");
        canal = this.canalService.validarCanal(canal);
        origen = this.origenService.validarOrigen(origen);
        this.solicitudFirmaService.saveSolicitudFima(codigoBiometrico, codigoCliente, identificacion, nombres, apellidoPaterno, apellidoMaterno, email, celular, domicilio, ciudad, origen, callback);
        String tipoSolicitud = this.env.getProperty("tws.tipotrans.fir");
        String tokenEncripted = this.baseService.getTokenFromJti();
        String tokenUA = this.cryptoService.decrypt(tokenEncripted);
        String twsCallback = this.env.getProperty("tws.callback.firma");
        String schemeFirma = this.env.getProperty("tws.schema.firma");
        String codigoInternoTws = UUID.randomUUID().toString();
        String buildedCodigoInterno = schemeFirma.replace("{cliente}", identificacion).replace("{canal}", canal).replace("{codigoInternoTws}", codigoInternoTws).replace("{codigoInterno}", codigoInternoTws).replace("{origen}", origen);
        ResponseFirmaUanataca response = this.uanatacaApi.getFirmaUanataca(codigoBiometrico, buildedCodigoInterno, identificacion, nombres, apellidoPaterno, apellidoMaterno, email, celular, domicilio, ciudad, documentos, twsCallback, tokenUA);
        String status = response.getStatus() == 200 ? "OK" : "ERROR: " + String.valueOf(response.getMessages());
        TSolicitud solicitud = new TSolicitud(this.cryptoService.encriptar(callback), this.cryptoService.encriptar(twsCallback), codigoBiometrico, codigoCliente, buildedCodigoInterno, tipoSolicitud, status, tokenEncripted);
        this.solicitudDAO.save((Object)solicitud);
        log.info("informacion del proceso guardada correctamente");
        if (response.getStatus() == 200) {
            return new ResponseEntity((Object)ApiResponse.ok((int)response.getStatus(), (Object)response.getData()), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((Object)ApiResponse.error((int)response.getStatus(), (Map)response.getMessages()), (HttpStatusCode)HttpStatus.valueOf((int)response.getStatus()));
    }

    public void reenviarCallbackBiometria(TCallbackBiometria callback, String tipo) {
        try {
            String code = callback.getCodigo();
            String originalCallback = this.baseService.getOriginalCallbackFromProcessCode(code, tipo);
            String string = this.cryptoService.decrypt(originalCallback);
        }
        catch (Exception e) {
            log.error("ERROR AL REALIZAR EL POST DE BIOMETRIA A LA 29", (Throwable)e);
        }
    }

    public void reenviarCallbackFirma(TCallbackFirma callback, String tipo) {
        try {
            String code = callback.getCodigo();
            String originalCallback = this.baseService.getOriginalCallbackFromProcessCode(code, tipo);
            String string = this.cryptoService.decrypt(originalCallback);
        }
        catch (Exception e) {
            log.error("ERROR AL REALIZAR EL POST DE FIRMAS A LA 29", (Throwable)e);
        }
    }

    public UanatacaServiceImpl(UanatacaServiceAPI uanatacaApi, SolicitudFirmaService solicitudFirmaService, DataBaseService baseService, SolicitudDAO solicitudDAO, CryptoMain cryptoService, Environment env, CanalService canalService, OrigenService origenService) {
        this.uanatacaApi = uanatacaApi;
        this.solicitudFirmaService = solicitudFirmaService;
        this.baseService = baseService;
        this.solicitudDAO = solicitudDAO;
        this.cryptoService = cryptoService;
        this.env = env;
        this.canalService = canalService;
        this.origenService = origenService;
    }
}

