/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.infrastructure.serviceImpl.biometria;

import com.eabrokers.logic.entity.firma.TSolicitudFirma;
import com.eabrokers.logic.infrastructure.service.biometria.SolicitudFirmaService;
import com.eabrokers.logic.repository.biometria.SolicitudFirmaDAO;
import ec.tws2.crypto.run.CryptoMain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class SolicitudFirmaServiceImpl
implements SolicitudFirmaService {
    private static final Logger log = LoggerFactory.getLogger(SolicitudFirmaServiceImpl.class);
    private final CryptoMain cryptoService;
    private final SolicitudFirmaDAO solicitudFirmaDAO;

    @Async
    public void saveSolicitudFima(String codigoBiometrico, String codigoCliente, String identificacion, String nombres, String apellidoPaterno, String apellidoMaterno, String email, String celular, String domicilio, String ciudad, String origen, String callback) {
        try {
            TSolicitudFirma solicitudFirma = new TSolicitudFirma();
            solicitudFirma.setCodigoBiometrico(codigoBiometrico);
            solicitudFirma.setCodigoCliente(codigoCliente);
            solicitudFirma.setIdentificacion(this.cryptoService.encriptar(identificacion));
            solicitudFirma.setNombres(this.cryptoService.encriptar(nombres));
            solicitudFirma.setApellidoPaterno(this.cryptoService.encriptar(apellidoPaterno));
            solicitudFirma.setApellidoMaterno(this.cryptoService.encriptar(apellidoMaterno));
            solicitudFirma.setEmail(this.cryptoService.encriptar(email));
            solicitudFirma.setCelular(this.cryptoService.encriptar(celular));
            solicitudFirma.setDomicilio(this.cryptoService.encriptar(domicilio));
            solicitudFirma.setCiudad(ciudad);
            solicitudFirma.setOrigen(origen);
            solicitudFirma.setCallback(callback);
            this.solicitudFirmaDAO.save((Object)solicitudFirma);
            log.info("Guardando la solicitud de firma");
        }
        catch (Exception e) {
            log.error("ERROR AL GUARDAR LA SOLICITUD DE FIRMA", (Throwable)e);
        }
    }

    public SolicitudFirmaServiceImpl(CryptoMain cryptoService, SolicitudFirmaDAO solicitudFirmaDAO) {
        this.cryptoService = cryptoService;
        this.solicitudFirmaDAO = solicitudFirmaDAO;
    }
}

