/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.infrastructure.serviceImpl.biometria;

import com.eabrokers.logic.entity.TClientesNotificados;
import com.eabrokers.logic.entity.biometria.TCallbackBiometria;
import com.eabrokers.logic.entity.firma.TCallbackFirma;
import com.eabrokers.logic.infrastructure.service.biometria.NotificacionService;
import com.eabrokers.logic.repository.biometria.ClientesNotificadosDAO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class NotificacionServiceImpl
implements NotificacionService {
    private static final Logger log = LoggerFactory.getLogger(NotificacionServiceImpl.class);
    private final SimpMessagingTemplate messagingTemplate;
    private final ClientesNotificadosDAO clientesNotificadosDAO;
    private final Environment env;

    public void notificarBiometria(TCallbackBiometria callback) {
        log.info("INGRESA AL SERVICIO DE NOTIFICACIONES BIOMETRIA");
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        HashMap<String, Object> body = new HashMap<String, Object>();
        String tipoProceso = this.env.getProperty("tws.tipotrans.bio");
        try {
            String pruebaProcesada = this.env.getProperty("uanataca.biometria.procesado");
            if (callback != null && callback.getData() != null && callback.getTipo() != null && callback.getTipo().equals(pruebaProcesada)) {
                String codigo = callback.getCodigo();
                BigDecimal rostroSimilitud = callback.getData().getRostroSimilitud();
                BigDecimal rostroSimilitudFrontal = callback.getData().getRostroSimilitudFrontal();
                BigDecimal rostroSimilitudSelfie = callback.getData().getRostroSimilitudSelfie();
                log.info("CALLBACK CORRECTO PARA ENVIAR AL CLIENTE, {}", (Object)codigo);
                response.put("status", Integer.valueOf(callback.getStatus()));
                body.put("codigo", codigo);
                body.put("rostroSimilitud", rostroSimilitud);
                body.put("rostroSimilitudFrontal", rostroSimilitudFrontal);
                body.put("rostroSimilitudSelfie", rostroSimilitudSelfie);
                response.put("data", body);
                this.sendNotificationToClients(codigo, response);
                this.saveStatusNotification(tipoProceso, codigo);
                return;
            }
        }
        catch (Exception e) {
            log.error("OCURRIO UN ERROR AL ENVIAR LA NOTIFICACION", (Throwable)e);
            int status = 500;
            response.put("status", Integer.valueOf(status));
            body.put("error", "Error al procesar la respuesta, esta solicitud volver\u00e1 a ser notificada en breve");
            response.put("messages", body);
            this.sendNotificationToClients(callback.getCodigo(), response);
            return;
        }
    }

    public void notificarFirma(TCallbackFirma callback) {
        log.info("INGRESA AL SERVICIO DE NOTIFICACIONES FIRMAS");
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        HashMap<String, String> body = new HashMap<String, String>();
        String tipoProceso = this.env.getProperty("tws.tipotrans.fir");
        try {
            if (callback != null && callback.getData() != null && callback.getData() != null && callback.getData().getTipo() != null && callback.getData().getArchivo() == null) {
                Integer status = callback.getStatus();
                String codigo = callback.getCodigo();
                String statusDocument = callback.getData().getTipo();
                log.info("CALLBACK CORRECTO PARA ENVIAR AL CLIENTE, {}", (Object)codigo);
                response.put("status", status);
                body.put("codigo", codigo);
                body.put("statusDocument", statusDocument);
                response.put("data", body);
                this.sendNotificationToClients(codigo, response);
                this.saveStatusNotification(tipoProceso, codigo);
                return;
            }
        }
        catch (Exception e) {
            log.error("OCURRIO UN ERROR AL ENVIAR LA NOTIFICACION", (Throwable)e);
            int status = 500;
            response.put("status", Integer.valueOf(status));
            body.put("error", "Error al procesar la respuesta, esta solicitud volver\u00e1 a ser notificada en breve");
            response.put("messages", body);
            this.sendNotificationToClients(callback.getCodigo(), response);
            return;
        }
    }

    public void notificarBiometriaFromAutoTask(int status, String codigo, BigDecimal rostroSimilitud, BigDecimal rostroSimilitudFrontal, BigDecimal rostroSimilitudSelfie) {
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        HashMap<String, Object> body = new HashMap<String, Object>();
        try {
            response.put("status", Integer.valueOf(status));
            body.put("codigo", codigo);
            body.put("rostroSimilitud", rostroSimilitud);
            body.put("rostroSimilitudFrontal", rostroSimilitudFrontal);
            body.put("rostroSimilitudSelfie", rostroSimilitudSelfie);
            response.put("data", body);
            this.sendNotificationToClients(codigo, response);
            return;
        }
        catch (Exception e) {
            log.error("OCURRIO UN ERROR AL ENVIAR LA NOTIFICACION DESDE EL AUTOTASK", (Throwable)e);
            status = 500;
            response.put("status", Integer.valueOf(status));
            body.put("error", "Error al procesar la respuesta, esta solicitud volver\u00e1 a ser notificada en breve");
            response.put("messages", body);
            this.sendNotificationToClients(codigo, response);
            return;
        }
    }

    public void notificarFirmaFromAutoTask(int status, String codigo, String statusDocument) {
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        HashMap<String, String> body = new HashMap<String, String>();
        try {
            response.put("status", Integer.valueOf(status));
            body.put("codigo", codigo);
            body.put("statusDocument", statusDocument);
            response.put("data", body);
            this.sendNotificationToClients(codigo, response);
            return;
        }
        catch (Exception e) {
            log.error("OCURRIO UN ERROR AL ENVIAR LA NOTIFICACION DESDE EL AUTOTASK", (Throwable)e);
            status = 500;
            response.put("status", Integer.valueOf(status));
            body.put("error", "Error al procesar la respuesta, esta solicitud volver\u00e1 a ser notificada en breve");
            response.put("messages", body);
            this.sendNotificationToClients(codigo, response);
            return;
        }
    }

    protected void saveStatusNotification(String tipoProceso, String codigo) {
        try {
            boolean notificado = false;
            this.clientesNotificadosDAO.save((Object)new TClientesNotificados(codigo, tipoProceso, Boolean.valueOf(notificado)));
        }
        catch (Exception e) {
            log.error("ERROR AL GUARDAR LA NOTIFICACION: ", (Throwable)e);
        }
    }

    @Async
    public void updateStatusNotification(String codigo) {
        try {
            boolean notificado = true;
            Optional notificacion = this.clientesNotificadosDAO.getNotificacionByCodeAndStatusNonActive(codigo);
            if (notificacion.isPresent()) {
                TClientesNotificados notifiToUpdate = (TClientesNotificados)notificacion.get();
                notifiToUpdate.setNotificado(Boolean.valueOf(notificado));
                this.clientesNotificadosDAO.save((Object)notifiToUpdate);
            } else {
                log.error("NO SE ENCONTRO LA NOTIFIACION CON EL CODIGO: " + codigo);
            }
        }
        catch (Exception e) {
            log.error("ERROR AL ACTUAZAR LA NOTIFICACION: ", (Throwable)e);
        }
    }

    @Async
    public void updateCounterNotification(String codigo, String tipo) {
        try {
            Optional notificacion = this.clientesNotificadosDAO.getNotificacionByCodeAndStatusAndTipo(codigo, tipo);
            if (notificacion.isPresent()) {
                TClientesNotificados notifiToUpdate = (TClientesNotificados)notificacion.get();
                notifiToUpdate.setIntentos(Integer.valueOf(notifiToUpdate.getIntentos() + 1));
                this.clientesNotificadosDAO.save((Object)notifiToUpdate);
            } else {
                log.error("NO SE ENCONTRO LA NOTIFIACION CON EL CODIGO: " + codigo);
            }
        }
        catch (Exception e) {
            log.error("ERROR AL ACTUAZAR LA NOTIFICACION: ", (Throwable)e);
        }
    }

    protected void sendNotificationToClients(String codigo, Map<String, Object> response) {
        log.info("ENVIANDO CALLBACK A USUARIO DE DESTINO PARA EL CODIGO, {}", (Object)codigo);
        try {
            this.messagingTemplate.convertAndSend((Object)"/biometria/".concat(codigo), response);
        }
        catch (Exception e) {
            log.error("ERROR AL NOTIFICAR AL CLIENTE CON EL CODIGO " + codigo, (Throwable)e);
        }
        log.info("CALLBACK ENVIADO CORRECTAMENTE A BIOMETRIAS");
    }

    public void testcallbackBiometria2(String tipo, String codigo, String rostroSimilitud, String rostroSimilitudFrontal, String rostroSimilitudSelfie) {
        Map<String, Map<String, String>> responseResult;
        log.info("SIMULACION DEL CALLBACK AL DESTINO");
        if (tipo.equals("ok")) {
            Map<String, String> response = Map.of("codigo", codigo, "rostroSimilitud", rostroSimilitud, "rostroSimilitudFrontal", rostroSimilitudFrontal, "rostroSimilitudReverso", rostroSimilitudSelfie);
            responseResult = Map.of("status", 200, "data", response);
        } else {
            Map<String, String> response = Map.of("error", "Algun tipo de error");
            responseResult = Map.of("status", 400, "messages", response);
        }
        this.messagingTemplate.convertAndSend((Object)("/biometria/" + codigo), responseResult);
        log.info("CALLBACK ENVIADO CORRECTAMENTE A BIOMETRIAS");
    }

    public NotificacionServiceImpl(SimpMessagingTemplate messagingTemplate, ClientesNotificadosDAO clientesNotificadosDAO, Environment env) {
        this.messagingTemplate = messagingTemplate;
        this.clientesNotificadosDAO = clientesNotificadosDAO;
        this.env = env;
    }
}

