/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.infrastructure.serviceImpl.biometria;

import com.eabrokers.logic.entity.TCanal;
import com.eabrokers.logic.infrastructure.service.biometria.CanalService;
import com.eabrokers.logic.repository.biometria.CanalDAO;
import com.eabrokers.utils.ApiResponse;
import com.eabrokers.utils.Utils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class CanalServiceImpl
implements CanalService {
    private static final Logger log = LoggerFactory.getLogger(CanalServiceImpl.class);
    private final CanalDAO canalDAO;

    public ResponseEntity<ApiResponse<?>> registrarNuevoCanal(String canal) {
        canal = canal.toUpperCase();
        Boolean existeCanal = this.canalDAO.existsByCanal(canal = canal.replace(" ", "_"));
        if (existeCanal.booleanValue()) {
            ApiResponse apiResponse = ApiResponse.error((int)400, (String)"Ya existe ese canal");
            return ResponseEntity.badRequest().body((Object)apiResponse);
        }
        this.canalDAO.save((Object)new TCanal(canal));
        ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)"Registro creado");
        return ResponseEntity.ok((Object)apiResponse);
    }

    public ResponseEntity<ApiResponse<?>> actualizarCanal(String canal, Boolean activo) {
        TCanal canalEncontrado = this.canalDAO.findByCanal(canal = Utils.limpiarCamposSoloLetras((String)canal));
        if (canalEncontrado != null) {
            canalEncontrado.setCanal(canal);
            canalEncontrado.setActivo(activo);
            this.canalDAO.save((Object)canalEncontrado);
            ApiResponse apiResponse = ApiResponse.ok((int)201, (Object)"Registro actualizado");
            return ResponseEntity.ok((Object)apiResponse);
        }
        ApiResponse apiResponse = ApiResponse.error((int)400, (String)"Registro no encontrado");
        return ResponseEntity.badRequest().body((Object)apiResponse);
    }

    public ResponseEntity<ApiResponse<?>> findAllChannels() {
        List canales = this.canalDAO.findAll();
        ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)canales);
        return ResponseEntity.ok((Object)apiResponse);
    }

    public ResponseEntity<ApiResponse<?>> findAllChannels4combo() {
        List canales = this.canalDAO.findListChannels();
        ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)canales);
        return ResponseEntity.ok((Object)apiResponse);
    }

    public String validarCanal(String canal) {
        Boolean existeCanal;
        if (canal == null || canal.isBlank()) {
            canal = "CANAL_SIN_ASIGNAR";
        }
        if (!(existeCanal = this.canalDAO.existsByCanal(canal = Utils.limpiarCamposSoloLetras((String)canal))).booleanValue()) {
            TCanal nuevocanal = new TCanal(canal);
            this.canalDAO.save((Object)nuevocanal);
        }
        return canal;
    }

    public CanalServiceImpl(CanalDAO canalDAO) {
        this.canalDAO = canalDAO;
    }
}

