/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.infrastructure.serviceImpl.biometria;

import com.eabrokers.exceptions.CustomException;
import com.eabrokers.logic.data.KeycloakResponseToken;
import com.eabrokers.logic.data.ResponseTokenUanataca;
import com.eabrokers.logic.infrastructure.service.biometria.AuthService;
import com.eabrokers.logic.infrastructure.service.biometria.DataBaseService;
import com.eabrokers.logic.restTemplate.service.KeycloakServiceAPI;
import com.eabrokers.logic.restTemplate.service.UanatacaServiceAPI;
import com.eabrokers.utils.ApiResponse;
import com.eabrokers.utils.DecodeAuthUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class AuthServiceImpl
implements AuthService {
    private static final Logger log = LoggerFactory.getLogger(AuthServiceImpl.class);
    private final Environment env;
    private final UanatacaServiceAPI uanatacaService;
    private final KeycloakServiceAPI keycloakService;
    private final DataBaseService baseService;

    public ResponseEntity<?> getToken(String authorizationHeader, String pin) {
        log.info("AuthService");
        try {
            if (authorizationHeader == null || pin == null || pin.isEmpty() || authorizationHeader.isEmpty() || !authorizationHeader.startsWith("Basic ")) {
                throw new CustomException("No autorizado", HttpStatus.UNAUTHORIZED);
            }
            if (authorizationHeader.startsWith("Basic ") && !pin.isEmpty()) {
                String[] credentials = DecodeAuthUtils.decode((String)authorizationHeader);
                String username = credentials[0];
                String password = credentials[1];
                System.out.println(this.env.getProperty("auth.keycloak.pin"));
                System.out.println(pin);
                System.out.println(this.env.getProperty("auth.keycloak.pin").endsWith(pin));
                if (this.env.getProperty("ambiente").equals("test") && !username.equalsIgnoreCase("TWS2-DESARROLLO")) {
                    ApiResponse apiResponse = ApiResponse.error((int)400, (String)"El usuario no corresponde al ambiente de pruebas");
                    return ResponseEntity.badRequest().body((Object)apiResponse);
                }
                ResponseTokenUanataca response = this.consumeToken(username, password, pin);
                log.info("response status token: {}", (Object)response.getStatus());
                if (response.getStatus() == 200) {
                    return new ResponseEntity((Object)ApiResponse.ok((int)response.getStatus(), (Object)response.getData()), (HttpStatusCode)HttpStatus.OK);
                }
                return new ResponseEntity((Object)ApiResponse.error((int)response.getStatus(), (Map)response.getMessages()), (HttpStatusCode)HttpStatus.valueOf((int)response.getStatus()));
            }
            throw new CustomException("No autorizado", HttpStatus.UNAUTHORIZED);
        }
        catch (Exception e) {
            throw new CustomException("No autorizado", HttpStatus.UNAUTHORIZED);
        }
    }

    protected ResponseTokenUanataca consumeToken(String username, String password, String pin) {
        log.info("AuthService.getTokenUanataca");
        KeycloakResponseToken tokenKeycloak = this.keycloakService.getTokenKeycloak(username, password, pin);
        if (tokenKeycloak == null || tokenKeycloak.getAccess_token() == null) {
            throw new CustomException("No se pudo validar sus credenciales, intentar con las credenciales correctas", HttpStatus.UNAUTHORIZED);
        }
        ResponseTokenUanataca responseUanataca = this.uanatacaService.getTokenUanataca(username, password, pin);
        String newToken = this.baseService.saveTokenResponse(responseUanataca, tokenKeycloak.getAccess_token());
        if (responseUanataca.getStatus() == 200) {
            Long time = tokenKeycloak.getExpires_in();
            LocalDateTime fechaActual = LocalDateTime.now();
            LocalDateTime expiresTokenKeycloak = fechaActual.plusSeconds(time).minusMinutes(5L);
            DateTimeFormatter dateTimeFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String dateTimeExpiresKeyCloak = dateTimeFormat.format(expiresTokenKeycloak);
            log.warn("Keycloak expires: " + dateTimeExpiresKeyCloak + " Uanataca expires: " + responseUanataca.getData().getTkn_fecha_vencimiento());
            responseUanataca.getData().setTkn_token(newToken);
            responseUanataca.getData().setTkn_fecha_vencimiento(dateTimeExpiresKeyCloak);
        }
        return responseUanataca;
    }

    public AuthServiceImpl(Environment env, UanatacaServiceAPI uanatacaService, KeycloakServiceAPI keycloakService, DataBaseService baseService) {
        this.env = env;
        this.uanatacaService = uanatacaService;
        this.keycloakService = keycloakService;
        this.baseService = baseService;
    }
}

