/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.entity.insurance;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Entity
@Table(name="t_insured_person")
public class TInsuredPerson {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="first_name", nullable=false)
    private String firstName;
    @Column(name="last_name", nullable=false)
    private String lastName;
    @Column(name="email", nullable=false)
    private String email;
    @Column(name="identification", nullable=false)
    private String identification;
    @Column(name="first_birthday", nullable=true)
    private String firstBirthday;
    @Column(name="gender", nullable=true)
    private String gender;
    @Column(name="occupation", nullable=true)
    private String occupation;
    @Column(name="middle_name", nullable=true)
    private String middleName;
    @Column(name="second_last_name", nullable=true)
    private String secondLastName;
    @Column(name="phone", nullable=true)
    private String phone;
    @Column(name="city", nullable=true)
    private String city;
    @Column(name="address", nullable=true)
    private String address;
    @Column(name="created_at")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdAt;

    @PrePersist
    protected void onCreated() {
        this.createdAt = new Date();
    }

    public String getFullName() {
        return Stream.of(this.firstName, this.middleName, this.lastName, this.secondLastName).filter(Objects::nonNull).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.joining(" "));
    }

    public Long getId() {
        return this.id;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getIdentification() {
        return this.identification;
    }

    public String getFirstBirthday() {
        return this.firstBirthday;
    }

    public String getGender() {
        return this.gender;
    }

    public String getOccupation() {
        return this.occupation;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public String getSecondLastName() {
        return this.secondLastName;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getCity() {
        return this.city;
    }

    public String getAddress() {
        return this.address;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public void setFirstBirthday(String firstBirthday) {
        this.firstBirthday = firstBirthday;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public void setOccupation(String occupation) {
        this.occupation = occupation;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public void setSecondLastName(String secondLastName) {
        this.secondLastName = secondLastName;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TInsuredPerson)) {
            return false;
        }
        TInsuredPerson other = (TInsuredPerson)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$identification = this.getIdentification();
        String other$identification = other.getIdentification();
        if (this$identification == null ? other$identification != null : !this$identification.equals(other$identification)) {
            return false;
        }
        String this$firstBirthday = this.getFirstBirthday();
        String other$firstBirthday = other.getFirstBirthday();
        if (this$firstBirthday == null ? other$firstBirthday != null : !this$firstBirthday.equals(other$firstBirthday)) {
            return false;
        }
        String this$gender = this.getGender();
        String other$gender = other.getGender();
        if (this$gender == null ? other$gender != null : !this$gender.equals(other$gender)) {
            return false;
        }
        String this$occupation = this.getOccupation();
        String other$occupation = other.getOccupation();
        if (this$occupation == null ? other$occupation != null : !this$occupation.equals(other$occupation)) {
            return false;
        }
        String this$middleName = this.getMiddleName();
        String other$middleName = other.getMiddleName();
        if (this$middleName == null ? other$middleName != null : !this$middleName.equals(other$middleName)) {
            return false;
        }
        String this$secondLastName = this.getSecondLastName();
        String other$secondLastName = other.getSecondLastName();
        if (this$secondLastName == null ? other$secondLastName != null : !this$secondLastName.equals(other$secondLastName)) {
            return false;
        }
        String this$phone = this.getPhone();
        String other$phone = other.getPhone();
        if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
            return false;
        }
        String this$city = this.getCity();
        String other$city = other.getCity();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TInsuredPerson;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $identification = this.getIdentification();
        result = result * 59 + ($identification == null ? 43 : $identification.hashCode());
        String $firstBirthday = this.getFirstBirthday();
        result = result * 59 + ($firstBirthday == null ? 43 : $firstBirthday.hashCode());
        String $gender = this.getGender();
        result = result * 59 + ($gender == null ? 43 : $gender.hashCode());
        String $occupation = this.getOccupation();
        result = result * 59 + ($occupation == null ? 43 : $occupation.hashCode());
        String $middleName = this.getMiddleName();
        result = result * 59 + ($middleName == null ? 43 : $middleName.hashCode());
        String $secondLastName = this.getSecondLastName();
        result = result * 59 + ($secondLastName == null ? 43 : $secondLastName.hashCode());
        String $phone = this.getPhone();
        result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
        String $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }

    public String toString() {
        return "TInsuredPerson(id=" + this.getId() + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", email=" + this.getEmail() + ", identification=" + this.getIdentification() + ", firstBirthday=" + this.getFirstBirthday() + ", gender=" + this.getGender() + ", occupation=" + this.getOccupation() + ", middleName=" + this.getMiddleName() + ", secondLastName=" + this.getSecondLastName() + ", phone=" + this.getPhone() + ", city=" + this.getCity() + ", address=" + this.getAddress() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ")";
    }
}

