/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.entity.insurance;

import com.eabrokers.logic.entity.insurance.TFileDocument;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Arrays;
import java.util.Date;

@Entity
@Table(name="t_file_document")
public class TFileDocument {
    @Id
    @Column(length=36)
    private String id;
    @Column(name="file", nullable=false)
    private byte[] file;
    @Column(name="content_type", nullable=false)
    private String contentType;
    @Column(name="file_public", nullable=false)
    private boolean filePublic;
    @Enumerated(value=EnumType.STRING)
    @Column(name="file_status", nullable=false)
    private FileStatus fileStatus;
    @Column(name="created_at")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdAt;

    @PrePersist
    protected void onCreate() {
        this.createdAt = new Date();
    }

    public String getId() {
        return this.id;
    }

    public byte[] getFile() {
        return this.file;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isFilePublic() {
        return this.filePublic;
    }

    public FileStatus getFileStatus() {
        return this.fileStatus;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setFile(byte[] file) {
        this.file = file;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setFilePublic(boolean filePublic) {
        this.filePublic = filePublic;
    }

    public void setFileStatus(FileStatus fileStatus) {
        this.fileStatus = fileStatus;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public String toString() {
        return "TFileDocument(id=" + this.getId() + ", file=" + Arrays.toString(this.getFile()) + ", contentType=" + this.getContentType() + ", filePublic=" + this.isFilePublic() + ", fileStatus=" + String.valueOf(this.getFileStatus()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ")";
    }
}

