/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.entity.insurance;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Arrays;
import java.util.Date;

@Entity
@Table(name="t_file")
public class TFile {
    @Id
    @Column(length=36)
    private String id;
    @Column(name="file", nullable=false)
    private byte[] file;
    @Column(name="file_name", nullable=false)
    private String fileName;
    @Column(name="content_type", nullable=false)
    private String contentType;
    @Column(name="file_public", nullable=false)
    private boolean filePublic;
    @Column(name="created_at")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdAt;

    @PrePersist
    protected void onCreate() {
        this.createdAt = new Date();
    }

    public TFile() {
    }

    public TFile(String id, byte[] file, String fileName, String contentType, boolean filePublic) {
        this.id = id;
        this.file = file;
        this.fileName = fileName;
        this.contentType = contentType;
        this.filePublic = filePublic;
    }

    public String getId() {
        return this.id;
    }

    public byte[] getFile() {
        return this.file;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isFilePublic() {
        return this.filePublic;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setFile(byte[] file) {
        this.file = file;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setFilePublic(boolean filePublic) {
        this.filePublic = filePublic;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TFile)) {
            return false;
        }
        TFile other = (TFile)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isFilePublic() != other.isFilePublic()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        if (!Arrays.equals(this.getFile(), other.getFile())) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TFile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFilePublic() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        result = result * 59 + Arrays.hashCode(this.getFile());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }

    public String toString() {
        return "TFile(id=" + this.getId() + ", file=" + Arrays.toString(this.getFile()) + ", fileName=" + this.getFileName() + ", contentType=" + this.getContentType() + ", filePublic=" + this.isFilePublic() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ")";
    }
}

