/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.entity.insurance;

import com.eabrokers.logic.entity.insurance.TDocumentTransaction;
import com.eabrokers.logic.entity.insurance.TDocumentTransactionDetail;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

@Entity
@Table(name="t_document_transaction")
public class TDocumentTransaction {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="financial_account_id")
    private Long financialAccountId;
    @Column(name="prima_type_id")
    private Long primaType;
    @Column(name="insurance_number", nullable=false)
    private Integer insuranceNumber;
    @Column(name="total_document", nullable=false)
    private Integer totalDocument;
    @Enumerated(value=EnumType.STRING)
    @Column(name="notify_type", nullable=false)
    private NotifyType notifyType;
    @Column(name="conversation_id", nullable=true)
    private String conversationId;
    @Column(name="uuid", nullable=true)
    private String uuid;
    @OneToMany
    @JoinColumn(name="document_transaction_id")
    private List<TDocumentTransactionDetail> documentTransactionDetail;
    @Enumerated(value=EnumType.STRING)
    @Column(name="document_status", nullable=false)
    private DocumentStatus documentStatus;
    @Column(name="created_at")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdAt;
    @Column(name="bill_date")
    private LocalDateTime billDate;

    @PrePersist
    protected void onCreated() {
        this.createdAt = new Date();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getFinancialAccountId() {
        return this.financialAccountId;
    }

    public void setFinancialAccountId(Long financialAccountId) {
        this.financialAccountId = financialAccountId;
    }

    public Long getPrimaType() {
        return this.primaType;
    }

    public void setPrimaType(Long primaType) {
        this.primaType = primaType;
    }

    public Integer getInsuranceNumber() {
        return this.insuranceNumber;
    }

    public void setInsuranceNumber(Integer insuranceNumber) {
        this.insuranceNumber = insuranceNumber;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Integer getTotalDocument() {
        return this.totalDocument;
    }

    public void setTotalDocument(Integer totalDocument) {
        this.totalDocument = totalDocument;
    }

    public NotifyType getNotifyType() {
        return this.notifyType;
    }

    public void setNotifyType(NotifyType notifyType) {
        this.notifyType = notifyType;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public List<TDocumentTransactionDetail> getDocumentTransactionDetail() {
        return this.documentTransactionDetail;
    }

    public void setDocumentTransactionDetail(List<TDocumentTransactionDetail> documentTransactionDetail) {
        this.documentTransactionDetail = documentTransactionDetail;
    }

    public DocumentStatus getDocumentStatus() {
        return this.documentStatus;
    }

    public void setDocumentStatus(DocumentStatus documentStatus) {
        this.documentStatus = documentStatus;
    }

    public LocalDateTime getBillDate() {
        return this.billDate;
    }

    public void setBillDate(LocalDateTime billDate) {
        this.billDate = billDate;
    }
}

