/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.entity;

import com.eabrokers.exceptions.CustomException;
import com.eabrokers.utils.Auditable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.io.Serializable;
import org.springframework.http.HttpStatus;

@Entity
@Table(name="t_origen")
public class TOrigen
extends Auditable<String>
implements Serializable {
    private static final long serialVersionUID = 6411287513698571586L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(length=70)
    private String origen;
    private Boolean activo;

    public TOrigen(String origen) {
        if (origen.length() > 70) {
            throw new CustomException("El largo maximo del campo 'origen' es de 70 caracteres", HttpStatus.BAD_REQUEST);
        }
        this.origen = origen;
        this.activo = true;
    }

    public TOrigen(String origen, Boolean activo) {
        if (origen.length() > 70) {
            throw new CustomException("El largo maximo del campo 'origen' es de 70 caracteres", HttpStatus.BAD_REQUEST);
        }
        this.origen = origen;
        this.activo = activo;
    }

    public Long getId() {
        return this.id;
    }

    public String getOrigen() {
        return this.origen;
    }

    public Boolean getActivo() {
        return this.activo;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setOrigen(String origen) {
        this.origen = origen;
    }

    public void setActivo(Boolean activo) {
        this.activo = activo;
    }

    public String toString() {
        return "TOrigen(id=" + this.getId() + ", origen=" + this.getOrigen() + ", activo=" + this.getActivo() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TOrigen)) {
            return false;
        }
        TOrigen other = (TOrigen)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$activo = this.getActivo();
        Boolean other$activo = other.getActivo();
        if (this$activo == null ? other$activo != null : !((Object)this$activo).equals(other$activo)) {
            return false;
        }
        String this$origen = this.getOrigen();
        String other$origen = other.getOrigen();
        return !(this$origen == null ? other$origen != null : !this$origen.equals(other$origen));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TOrigen;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $activo = this.getActivo();
        result = result * 59 + ($activo == null ? 43 : ((Object)$activo).hashCode());
        String $origen = this.getOrigen();
        result = result * 59 + ($origen == null ? 43 : $origen.hashCode());
        return result;
    }
}

