/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.controller;

import com.eabrokers.logic.dto.PreInsuredDocumentDTO;
import com.eabrokers.logic.infrastructure.service.insurance.SignDocumentService;
import com.eabrokers.logic.infrastructure.service.signPremise.SignWithCertificate;
import com.eabrokers.logic.model.FilesToSignModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"v1/signDocument"})
public class SignDocumentController {
    private static final Logger log = LoggerFactory.getLogger(SignDocumentController.class);
    private final SignDocumentService signDocumentService;
    private final SignWithCertificate signWithCertificate;

    @PostMapping(value={"/withCertificate"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> uploadDocument(@RequestPart(value="certificate") MultipartFile certificate, @RequestPart(value="password") String password, @RequestPart(value="json") String jsonString) {
        return this.signWithCertificate.signDocWithCertificate(certificate, password, jsonString);
    }

    @PostMapping(value={"signDocWithQR"})
    public ResponseEntity<?> postSignDocWithQR(@RequestBody FilesToSignModel filesToSignModel) throws Exception {
        return this.signWithCertificate.signDocWithQR(filesToSignModel);
    }

    @PostMapping(value={"preSignDocumentAuthorization"})
    public ResponseEntity<?> postPreSignDocumentAuthorization(@RequestBody PreInsuredDocumentDTO preInsuredDocumentDTO) {
        return this.signDocumentService.preSignDocumentAuthorization(preInsuredDocumentDTO);
    }

    @PostMapping(value={"documentTransactionById"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<?> postDocumentTransactionById(@RequestParam Long documentTransactionId) {
        return this.signDocumentService.documentTransactionById(documentTransactionId);
    }

    public SignDocumentController(SignDocumentService signDocumentService, SignWithCertificate signWithCertificate) {
        this.signDocumentService = signDocumentService;
        this.signWithCertificate = signWithCertificate;
    }
}

