/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.controller;

import com.eabrokers.logic.data.ClienteConsumo;
import com.eabrokers.logic.data.RespuestaRobot;
import com.eabrokers.logic.infrastructure.service.lhia.ChatService;
import com.eabrokers.logic.response.SolicitudSeguroResponse;
import com.eabrokers.utils.JsonValidatorUtil;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"lhia"})
public class LhiaController {
    private static final Logger log = LoggerFactory.getLogger(LhiaController.class);
    @Autowired
    private ChatService chatService;

    @PostMapping(value={"/pregunta"}, consumes={"application/json; charset=UTF-8"})
    @CrossOrigin
    public RespuestaRobot getProductCLiente(@RequestBody ClienteConsumo cliente) throws Exception {
        log.info("request {}", (Object)cliente);
        RespuestaRobot robot = new RespuestaRobot();
        String answer = this.chatService.pregunta(cliente.getQuestion(), cliente.getIdentificador());
        Optional dataResponse = JsonValidatorUtil.parsearSolicitudSeguro((String)answer);
        if (dataResponse.isPresent()) {
            robot.setRespuesta("OK");
            robot.setContent((SolicitudSeguroResponse)dataResponse.get());
            return robot;
        }
        robot.setRespuesta(answer);
        robot.setContent(null);
        return robot;
    }
}

