/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.controller;

import com.eabrokers.exceptions.CustomException;
import com.eabrokers.logic.data.RequestModelStampTest;
import com.eabrokers.logic.infrastructure.service.biometria.FirmaService;
import com.eabrokers.utils.ApiResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"sign"})
public class FirmaController {
    private static final Logger log = LoggerFactory.getLogger(FirmaController.class);
    @Autowired
    private FirmaService firmaService;

    @PostMapping(value={"restamp"})
    public ResponseEntity<?> restamp(@RequestParam String base64, @RequestParam String identificacion, @RequestParam String coordenadas) throws Exception, CustomException {
        log.info("FirmaController.signWithQrCode");
        return this.firmaService.restampSign(base64, identificacion, coordenadas);
    }

    @PostMapping(value={"just-stamp"})
    public ResponseEntity<?> justEstampTest(@RequestBody RequestModelStampTest body) throws Exception, CustomException {
        log.info("API ESTAMPADO DOCUMENOTS");
        String base64Signed = this.firmaService.restampSignTest(body);
        ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)base64Signed);
        return ResponseEntity.ok((Object)apiResponse);
    }
}

