/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.controller;

import com.eabrokers.logic.infrastructure.service.insurance.DocumentTransactionService;
import com.eabrokers.logic.infrastructure.service.insurance.TransactionSummaryViewService;
import java.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"v1/documentTransaction"})
public class DocumentTransactionController {
    private static final Logger log = LoggerFactory.getLogger(DocumentTransactionController.class);
    @Autowired
    private DocumentTransactionService service;
    @Autowired
    private TransactionSummaryViewService transactionSummaryViewService;

    @GetMapping(value={"listDocumentPendingBill"})
    public ResponseEntity<?> getListDocumentPendingBill() {
        return this.transactionSummaryViewService.listTransactionSummaryView();
    }

    @PostMapping(value={"documentsFindById"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<?> getDocumentsFindById(@RequestParam(value="documentTransactionId") Long documentTransactionId) {
        return this.transactionSummaryViewService.getTransactionSummaryViewById(documentTransactionId);
    }

    @PostMapping(value={"documentsUpdateBill"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<?> putDocumentsUpdateBill(@RequestParam(value="documentTransactionId") Long documentTransactionId) {
        return this.service.putDocumentsUpdateBill(documentTransactionId, "BILLED");
    }

    @PostMapping(value={"documentsHistory"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<?> getDocumentsHistory(@RequestParam(value="startDate", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate startDate, @RequestParam(value="endDate", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate endDate, Pageable pageable) {
        return this.service.getDocumentsHistory(pageable, startDate, endDate, "BILLED");
    }

    @PostMapping(value={"documentsByStatus"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<?> getDocumentsByStatus(@RequestParam(value="status") String status) {
        return this.service.getDocumentsByStatus(status);
    }

    @PostMapping(value={"findTransactions"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<?> findTransactions(@RequestParam(value="startDate", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate startDate, @RequestParam(value="endDate", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate endDate, Pageable pageable) {
        return this.service.findTransactions(pageable, startDate, endDate);
    }

    @PostMapping(value={"transactionById"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<?> getDocumentsByTransactionId(@RequestParam(value="transactionId") Long transactionId) {
        return this.service.getDocumentsByTransactionId(transactionId);
    }
}

