/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.controller;

import com.eabrokers.logic.dto.DocumentInsuranceDTO;
import com.eabrokers.logic.infrastructure.service.insurance.DocumentInsuranceService;
import com.eabrokers.logic.infrastructure.service.signPremise.SignWithCertificate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"v1/documentInsurance"})
public class DocumentInsuranceController {
    private static final Logger log = LoggerFactory.getLogger(DocumentInsuranceController.class);
    @Autowired
    private DocumentInsuranceService service;
    @Autowired
    private SignWithCertificate signWithCertificate;

    @GetMapping(value={"listDocumentInsurance"})
    public ResponseEntity<?> getDocumentInsurances() {
        return this.service.listDocumentInsurance();
    }

    @PostMapping(value={"save"})
    public ResponseEntity<?> postSaveDocumentInsurance(@RequestBody DocumentInsuranceDTO documentInsuranceDTO) {
        return this.service.saveDocumentInsurance(documentInsuranceDTO);
    }

    @PostMapping(value={"/findDocumentByStatusRole"})
    public ResponseEntity<?> getDocumentInsuranceByStatusAndRole(@RequestParam(value="signstatus") String status, @RequestParam(value="role") String role, Pageable pageable) {
        return this.service.findDocumentInsuranceView(status, role, pageable);
    }

    @PostMapping(value={"proccesFilestoSign"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> postProccesFilestoSign(@RequestParam(value="firma", required=false) MultipartFile firma, @RequestParam(value="password", required=false) String password, @RequestParam(value="identificacion", required=false) String identification, @RequestParam(value="data", required=false) List<String> listDocumentsID) {
        return this.signWithCertificate.signAllDOcuments(firma, password, identification, listDocumentsID);
    }
}

