/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.controller;

import com.eabrokers.logic.dto.FileDTO;
import com.eabrokers.logic.infrastructure.service.insurance.FileDocumentService;
import com.eabrokers.logic.infrastructure.service.insurance.FileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"v1/files"})
public class DocumentFileController {
    private static final Logger log = LoggerFactory.getLogger(DocumentFileController.class);
    @Autowired
    private FileService fileService;
    @Autowired
    private FileDocumentService fileDocumentService;

    @GetMapping(value={"assets/{fileId:.+}"})
    public ResponseEntity<byte[]> getFileById(@PathVariable String fileId) {
        log.info("getFileById: " + fileId);
        return this.fileService.getByteFileById(fileId);
    }

    @GetMapping(value={"docs/{fileId:.+}"})
    public ResponseEntity<byte[]> getDocumentFileById(@PathVariable String fileId) {
        return this.fileDocumentService.getByteFileById(fileId);
    }

    @PostMapping(value={"update-file"})
    public ResponseEntity<?> updateFileById(@RequestBody FileDTO fileDTO) {
        return this.fileService.updateFileById(fileDTO);
    }
}

