/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.controller;

import com.eabrokers.logic.entity.biometria.TCallbackBiometria;
import com.eabrokers.logic.entity.firma.TCallbackFirma;
import com.eabrokers.logic.infrastructure.service.biometria.DataBaseService;
import com.eabrokers.logic.infrastructure.service.biometria.NotificacionService;
import com.eabrokers.logic.infrastructure.service.biometria.UanatacaService;
import com.eabrokers.logic.infrastructure.service.insurance.BiometricDocumentService;
import com.eabrokers.utils.Utils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/callback"})
public class CallbackController {
    private static final Logger log = LoggerFactory.getLogger(CallbackController.class);
    private final DataBaseService dataBaseService;
    private final UanatacaService uanatacaService;
    private final NotificacionService notificacionService;
    private final ObjectMapper objectMapper;
    private final Environment env;
    private final BiometricDocumentService biometricDocumentService;

    @PostMapping(value={"/biometria"})
    public ResponseEntity<?> callbackBiometria(@RequestBody Map<String, Object> callback) {
        log.info("Recibiendo callback con el resultado de la biometria");
        TCallbackBiometria tCallbackBiometria = null;
        try {
            Map validateBiometricObject = Utils.validateBiometricObject(callback);
            String jsonValidado = this.objectMapper.writeValueAsString((Object)validateBiometricObject);
            tCallbackBiometria = (TCallbackBiometria)this.objectMapper.readValue(jsonValidado, TCallbackBiometria.class);
        }
        catch (Exception e) {
            log.error("Error al convertir el callback a JSON", (Throwable)e);
            return ResponseEntity.badRequest().build();
        }
        this.dataBaseService.guardarCallbackBiometria(tCallbackBiometria);
        this.notificacionService.notificarBiometria(tCallbackBiometria);
        log.info("CALLBACK ENVIADO CORRECTAMENTE A BIOMETRIAS");
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/firma"})
    public ResponseEntity<?> callbackFirma(@RequestBody TCallbackFirma callback) {
        log.info("Recibiendo callback con el resultado de la firma");
        String tipoSolicitud = this.env.getProperty("tws.tipotrans.fir");
        this.dataBaseService.guardarCallbackFirma(callback);
        this.uanatacaService.reenviarCallbackFirma(callback, tipoSolicitud);
        this.notificacionService.notificarFirma(callback);
        log.info("CALLBACK ENVIADO CORRECTAMENTE A FIRMAS");
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/firmaV2"})
    public Object callbackDocuments2(@RequestBody Object request) {
        String uniqueFileName = "callback_data_" + System.currentTimeMillis() + "_" + String.valueOf(UUID.randomUUID()) + ".json";
        String directoryPath = "data/";
        new File(directoryPath).mkdirs();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(directoryPath + uniqueFileName));){
            ObjectMapper objectMapper = new ObjectMapper();
            String jsonString = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(request);
            writer.write(jsonString);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "Error al guardar los datos";
        }
        return "Datos guardados en: " + directoryPath + uniqueFileName;
    }

    @PostMapping(value={"/firmaV1"})
    public ResponseEntity<?> callbackBiometriaV2(@RequestBody Map<String, Object> callback) {
        log.info("firmaV1-> Recibiendo callback con el resultado de la biometria");
        if (callback == null || callback.get("tipo") == null) {
            log.error("El campo 'tipo' es nulo o no est\u00e1 presente en el callback");
            return ResponseEntity.badRequest().body((Object)"El campo 'tipo' es requerido");
        }
        TCallbackBiometria tCallbackBiometria = null;
        try {
            Map validateBiometricObject = Utils.validateBiometricObject(callback);
            String jsonValidado = this.objectMapper.writeValueAsString((Object)validateBiometricObject);
            tCallbackBiometria = (TCallbackBiometria)this.objectMapper.readValue(jsonValidado, TCallbackBiometria.class);
        }
        catch (Exception e) {
            log.error("Error al convertir el callback a JSON", (Throwable)e);
            return ResponseEntity.badRequest().build();
        }
        this.dataBaseService.guardarCallbackBiometria(tCallbackBiometria);
        this.notificacionService.notificarBiometria(tCallbackBiometria);
        log.info("CALLBACK ENVIADO CORRECTAMENTE A BIOMETRIAS");
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/biometria-firma"})
    public ResponseEntity<?> callbackFirmaBiometria(@RequestBody Map<String, Object> callback) {
        log.info("biometria-firma-> Recibiendo callback con el resultado de la firma-biometria");
        try {
            Object typeCallback = callback.get("tipo");
            String tipoSolicitud = this.env.getProperty("tws.tipotrans.bio-fir");
            if (typeCallback != null) {
                log.info("Recibiendo callback con el resultado de la firma-biometria: tipo biometria: {}", (Object)tipoSolicitud);
                Map validateBiometricObject = Utils.validateBiometricObject(callback);
                String jsonValidado = this.objectMapper.writeValueAsString((Object)validateBiometricObject);
                TCallbackBiometria tCallbackBiometria = (TCallbackBiometria)this.objectMapper.readValue(jsonValidado, TCallbackBiometria.class);
                this.dataBaseService.guardarCallbackBiometria(tCallbackBiometria);
                this.notificacionService.notificarBiometria(tCallbackBiometria);
            } else {
                log.info("Recibiendo callback con el resultado de la firma-biometria: tipo firma: {}", (Object)tipoSolicitud);
                String jsonFirma = this.objectMapper.writeValueAsString(callback);
                TCallbackFirma tCallbackFirma = (TCallbackFirma)this.objectMapper.readValue(jsonFirma, TCallbackFirma.class);
                this.dataBaseService.guardarCallbackFirma(tCallbackFirma);
            }
            this.biometricDocumentService.callbackDocumentsMap(callback);
        }
        catch (Exception e) {
            log.error("Error al convertir el callback a JSON", (Throwable)e);
            return ResponseEntity.badRequest().build();
        }
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/test"})
    public ResponseEntity<?> callbackFirma(@RequestBody Object callback) {
        log.info("Recibiendo callback test");
        log.info("CALLBACK ENVIADO CORRECTAMENTE A FIRMAS");
        return ResponseEntity.ok().build();
    }

    public CallbackController(DataBaseService dataBaseService, UanatacaService uanatacaService, NotificacionService notificacionService, ObjectMapper objectMapper, Environment env, BiometricDocumentService biometricDocumentService) {
        this.dataBaseService = dataBaseService;
        this.uanatacaService = uanatacaService;
        this.notificacionService = notificacionService;
        this.objectMapper = objectMapper;
        this.env = env;
        this.biometricDocumentService = biometricDocumentService;
    }
}

