/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.controller;

import com.eabrokers.logic.dto.DocumentsSignDTO;
import com.eabrokers.logic.infrastructure.service.insurance.BiometricDocumentService;
import com.eabrokers.logic.request.CallbackDocumentRequest;
import com.eabrokers.logic.response.ResponseResult;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"v1/biometricDocument"})
public class BiometricDocumentController {
    @Autowired
    private BiometricDocumentService biometricDocumentService;

    @PostMapping(value={"callbackDocuments"})
    public ResponseEntity<ResponseResult<?>> callbackDocuments(@RequestBody CallbackDocumentRequest documentRequest) {
        return this.biometricDocumentService.callbackDocuments(documentRequest);
    }

    @PostMapping(value={"listDocumentsSign"})
    public ResponseEntity<ResponseResult<?>> listDocumentsSign(@RequestBody DocumentsSignDTO documentsSignDTO) {
        return this.biometricDocumentService.listDocumentsSign(documentsSignDTO);
    }

    @PostMapping(value={"callbackDocumentsV2"})
    public Object callbackDocuments2(@RequestBody Object request) {
        String uniqueFileName = "callback_data_" + System.currentTimeMillis() + "_" + String.valueOf(UUID.randomUUID()) + ".json";
        String directoryPath = "data/";
        new File(directoryPath).mkdirs();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(directoryPath + uniqueFileName));){
            ObjectMapper objectMapper = new ObjectMapper();
            String jsonString = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(request);
            writer.write(jsonString);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "Error al guardar los datos";
        }
        return "Datos guardados en: " + directoryPath + uniqueFileName;
    }
}

