/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.client;

import com.eabrokers.logic.model.KeyEmail;
import com.eabrokers.logic.request.EmailRequest;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class EmailApiClient {
    private final Environment env;
    @Autowired
    RestTemplate restTemplate;

    public String getTokenAdminEmail() throws Exception {
        String adminEmailToken = Objects.requireNonNull(this.env.getProperty("endpoint.admin.email_token"), "La URL de la API de correo no puede ser nula");
        String adminEmailPassword = this.env.getProperty("property.server.email_password");
        String adminEmailUsername = this.env.getProperty("property.server.email_username");
        String adminEmailClientId = this.env.getProperty("property.server.email_client_id");
        String adminEmailGrantType = this.env.getProperty("property.server.email_grant_type");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"client_id", (Object)adminEmailClientId);
        map.add((Object)"username", (Object)adminEmailUsername);
        map.add((Object)"grant_type", (Object)adminEmailGrantType);
        map.add((Object)"password", (Object)adminEmailPassword);
        HttpEntity entity = new HttpEntity((Object)map, (MultiValueMap)headers);
        ResponseEntity answer = this.restTemplate.exchange(adminEmailToken, HttpMethod.POST, entity, KeyEmail.class, new Object[0]);
        KeyEmail responseBody = Objects.requireNonNull((KeyEmail)answer.getBody(), "El cuerpo de la respuesta es nulo");
        return responseBody.getAccess_token();
    }

    public boolean sendEmail(EmailRequest emailRequest) throws Exception {
        String adminEmailApi = Objects.requireNonNull(this.env.getProperty("endpoint.admin.email_api_base"), "La URL de la API de correo no puede ser nula");
        String tokenAdminEmail = this.getTokenAdminEmail();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(tokenAdminEmail);
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonEmailModel = objectMapper.writeValueAsString((Object)emailRequest);
        HttpEntity request = new HttpEntity((Object)jsonEmailModel, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(adminEmailApi, (Object)request, EmailRequest.class, new Object[0]);
        return response.getStatusCode() == HttpStatus.OK;
    }

    public EmailApiClient(Environment env, RestTemplate restTemplate) {
        this.env = env;
        this.restTemplate = restTemplate;
    }
}

