/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.client;

import com.eabrokers.logic.dto.NotificationBotpressDTO;
import com.eabrokers.logic.dto.WebhookMessageDTO;
import java.util.Objects;
import java.util.Optional;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class BotpressApiClient {
    private final Environment env;

    public Optional<String> sendWebhookMessage(NotificationBotpressDTO notify) {
        String apiBotpressWebhook = Objects.requireNonNull(this.env.getProperty("api.botpress.webhook"), "La URL de la API de Botpress no puede ser nula");
        try {
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            WebhookMessageDTO body = this.buildWebhookMessage(notify);
            HttpEntity requestEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
            ResponseEntity response = restTemplate.exchange(apiBotpressWebhook, HttpMethod.POST, requestEntity, String.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                return Optional.of("OK");
            }
            return Optional.empty();
        }
        catch (RestClientException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    private WebhookMessageDTO buildWebhookMessage(NotificationBotpressDTO notify) {
        WebhookMessageDTO.WebhookContent content = new WebhookMessageDTO.WebhookContent();
        content.setMessage(notify.getMessage());
        content.setType(notify.getTypeNotify());
        content.setUuid(notify.getUuid());
        content.setIdDocumentTransaction(notify.getIdDocumentTransaction());
        content.setDocumentStatus(notify.getDocumentStatus());
        WebhookMessageDTO body = new WebhookMessageDTO();
        body.setConversationId(notify.getConversationId());
        body.setContent(content);
        return body;
    }

    public BotpressApiClient(Environment env) {
        this.env = env;
    }
}

