/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.common.transactions;

import com.eabrokers.common.enums.StatusTransactions;
import com.eabrokers.logic.response.ResponseResult;
import com.eabrokers.utils.ValidationsApi;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;

public class TransactionCustom {
    public static ResponseEntity<ResponseResult<?>> errorFields(BindingResult resultBinding) {
        Map errors = ValidationsApi.validateErrorField((BindingResult)resultBinding);
        return new ResponseEntity((Object)new ResponseResult(false, StatusTransactions.ERROR, "ERROR IN FIELDS", (Object)errors), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    public static ResponseEntity<ResponseResult<?>> ok() {
        return ResponseEntity.ok((Object)new ResponseResult(true, StatusTransactions.SUCCESS, "OK", (Object)true));
    }

    public static ResponseEntity<ResponseResult<?>> ok(Object payload) {
        return ResponseEntity.ok((Object)new ResponseResult(true, StatusTransactions.SUCCESS, "OK", payload));
    }

    public static ResponseEntity<ResponseResult<?>> ok(StatusTransactions type, String message) {
        StatusTransactions finalType = type != null ? type : StatusTransactions.SUCCESS;
        String finalMessage = message != null ? message : "OK";
        return ResponseEntity.ok((Object)new ResponseResult(true, finalType, finalMessage, (Object)true));
    }

    public static ResponseEntity<ResponseResult<?>> ok(StatusTransactions type, String message, Object payload) {
        StatusTransactions finalType = type != null ? type : StatusTransactions.SUCCESS;
        String finalMessage = message != null ? message : "OK";
        return ResponseEntity.ok((Object)new ResponseResult(true, finalType, finalMessage, payload));
    }

    public static ResponseEntity<ResponseResult<?>> error() {
        return new ResponseEntity((Object)new ResponseResult(false, StatusTransactions.ERROR, "ERROR", null), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    public static ResponseEntity<ResponseResult<?>> error(String message) {
        return new ResponseEntity((Object)new ResponseResult(false, StatusTransactions.ERROR, message, null), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    public static ResponseEntity<ResponseResult<?>> error(StatusTransactions type, String message) {
        StatusTransactions finalType = type != null ? type : StatusTransactions.ERROR;
        String finalMessage = message != null ? message : "ERROR";
        return new ResponseEntity((Object)new ResponseResult(false, finalType, finalMessage, null), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }
}

