/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.WebSocket;

import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.messaging.SessionConnectEvent;
import org.springframework.web.socket.messaging.SessionDisconnectEvent;

@Component
public class WebSocketEventListener {
    private static final Logger log = LoggerFactory.getLogger(WebSocketEventListener.class);
    private final ConcurrentHashMap<String, String> sessions = new ConcurrentHashMap();

    @EventListener
    public void handleWebSocketConnectListener(SessionConnectEvent event) {
        StompHeaderAccessor headerAccessor = StompHeaderAccessor.wrap((Message)event.getMessage());
        String sessionId = headerAccessor.getSessionId();
        this.sessions.put(sessionId, "CONNECTED");
        log.warn("Received a new web socket connection. Total active sessions: " + this.sessions.size());
    }

    @EventListener
    public void handleWebSocketDisconnectListener(SessionDisconnectEvent event) {
        StompHeaderAccessor headerAccessor = StompHeaderAccessor.wrap((Message)event.getMessage());
        String sessionId = headerAccessor.getSessionId();
        this.sessions.remove(sessionId);
        log.warn("Disconnected web socket connection. Total active sessions: " + this.sessions.size());
    }

    public ConcurrentHashMap<String, String> getSessions() {
        return this.sessions;
    }
}

