/*
 * Decompiled with CFR 0.152.
 */
package com.firma.logic.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.firma.logic.entity.biometria.TCallbackBiometria;
import com.firma.logic.entity.firma.TCallbackFirma;
import com.firma.logic.service.DataBaseService;
import com.firma.logic.service.NotificacionService;
import com.firma.logic.service.UanatacaService;
import com.firma.utils.DecriptUtils;
import com.firma.utils.Utils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/callback"})
public class CallbackController {
    private static final Logger log = LoggerFactory.getLogger(CallbackController.class);
    private final DataBaseService dataBaseService;
    private final UanatacaService uanatacaService;
    private final NotificacionService notificacionService;
    private final ObjectMapper objectMapper;
    private final Environment env;
    private final DecriptUtils decriptUtils;

    @PostMapping(value={"/biometria"})
    public ResponseEntity<?> callbackBiometria(@RequestBody Map<String, Object> callback) {
        log.info("Recibiendo callback con el resultado de la biometria");
        String tipoSolicitud = this.env.getProperty("tws.tipotrans.bio");
        TCallbackBiometria tCallbackBiometria = null;
        try {
            Map validateBiometricObject = Utils.validateBiometricObject(callback);
            String jsonValidado = this.objectMapper.writeValueAsString((Object)validateBiometricObject);
            tCallbackBiometria = (TCallbackBiometria)this.objectMapper.readValue(jsonValidado, TCallbackBiometria.class);
        }
        catch (Exception e) {
            log.error("Error al convertir el callback a JSON", (Throwable)e);
            return ResponseEntity.badRequest().build();
        }
        this.dataBaseService.guardarCallbackBiometria(tCallbackBiometria);
        this.uanatacaService.reenviarCallbackBiometria(this.decriptUtils.decryptPhotos(tCallbackBiometria), tipoSolicitud);
        this.notificacionService.notificarBiometria(tCallbackBiometria);
        log.info("CALLBACK ENVIADO CORRECTAMENTE A BIOMETRIAS");
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/firma"})
    public ResponseEntity<?> callbackFirma(@RequestBody TCallbackFirma callback) {
        log.info("Recibiendo callback con el resultado de la firma");
        String tipoSolicitud = this.env.getProperty("tws.tipotrans.fir");
        this.dataBaseService.guardarCallbackFirma(callback);
        this.uanatacaService.reenviarCallbackFirma(callback, tipoSolicitud);
        this.notificacionService.notificarFirma(callback);
        log.info("CALLBACK ENVIADO CORRECTAMENTE A FIRMAS");
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/biometria-firma"})
    public ResponseEntity<?> callbackFirmaBiometria(@RequestBody Map<String, Object> callback) {
        try {
            Object typeCallback = callback.get("tipo");
            String tipoSolicitud = this.env.getProperty("tws.tipotrans.bio-fir");
            if (typeCallback != null) {
                Map validateBiometricObject = Utils.validateBiometricObject(callback);
                String jsonValidado = this.objectMapper.writeValueAsString((Object)validateBiometricObject);
                TCallbackBiometria tCallbackBiometria = (TCallbackBiometria)this.objectMapper.readValue(jsonValidado, TCallbackBiometria.class);
                this.dataBaseService.guardarCallbackBiometria(tCallbackBiometria);
                this.uanatacaService.reenviarCallbackBiometria(tCallbackBiometria, tipoSolicitud);
                log.info("Recibiendo callback con el resultado de la firma-biometria: tipo biometria: {}", (Object)tipoSolicitud);
            } else {
                String jsonFirma = this.objectMapper.writeValueAsString(callback);
                TCallbackFirma tCallbackFirma = (TCallbackFirma)this.objectMapper.readValue(jsonFirma, TCallbackFirma.class);
                this.dataBaseService.guardarCallbackFirma(tCallbackFirma);
                this.uanatacaService.reenviarCallbackFirma(tCallbackFirma, tipoSolicitud);
                log.info("Recibiendo callback con el resultado de la firma-biometria: tipo firma: {}", (Object)tipoSolicitud);
            }
        }
        catch (Exception e) {
            log.error("Error al convertir el callback a JSON", (Throwable)e);
            return ResponseEntity.badRequest().build();
        }
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/test"})
    public ResponseEntity<?> callbackFirma(@RequestBody Object callback) {
        log.info("Recibiendo callback test");
        log.info("CALLBACK ENVIADO CORRECTAMENTE A FIRMAS");
        return ResponseEntity.ok().build();
    }

    public CallbackController(DataBaseService dataBaseService, UanatacaService uanatacaService, NotificacionService notificacionService, ObjectMapper objectMapper, Environment env, DecriptUtils decriptUtils) {
        this.dataBaseService = dataBaseService;
        this.uanatacaService = uanatacaService;
        this.notificacionService = notificacionService;
        this.objectMapper = objectMapper;
        this.env = env;
        this.decriptUtils = decriptUtils;
    }
}

