/*
 * Decompiled with CFR 0.152.
 */
package com.firma.utils;

import com.firma.exceptions.CustomException;
import com.firma.logic.model.LocalizacionModel;
import org.springframework.http.HttpStatus;

public class LocalizacionUtils {
    protected float defaultX = 0.0f;
    protected float defaultY = 0.0f;
    protected int page = 1;

    public static LocalizacionModel getCoordenadas(String coordenadaX, String coordenadaY, String pagina, int totalPageNumber) throws CustomException, Exception {
        if (coordenadaX == null && coordenadaY == null && pagina == null) {
            return new LocalizacionModel(totalPageNumber, 0.0f, 10.0f);
        }
        LocalizacionModel localizacionModel = new LocalizacionModel();
        float x = Float.parseFloat(coordenadaX);
        float y = Float.parseFloat(coordenadaY);
        localizacionModel.setX(x);
        localizacionModel.setY(y);
        localizacionModel.setPage(pagina.equalsIgnoreCase("LAST") ? totalPageNumber : Integer.parseInt(pagina));
        if (localizacionModel.getPage() > totalPageNumber) {
            throw new CustomException("La p\u00e1gina indicada no existe", HttpStatus.BAD_REQUEST);
        }
        return localizacionModel;
    }
}

