/*
 * Decompiled with CFR 0.152.
 */
package com.firma.utils;

import com.firma.exceptions.CustomException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Base64;
import java.util.UUID;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.util.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class DocumentUtils {
    private static final Logger log = LoggerFactory.getLogger(DocumentUtils.class);

    public static String allPagesVertical(String base64, String rootPath) {
        PDDocument document;
        log.info("ROTANDO TODAS LAS P\u00c1GINAS DEL DOCUMENTO PDF A VERTICAL");
        try {
            byte[] pdfBytes = Base64.getDecoder().decode(base64);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
            document = PDDocument.load((InputStream)inputStream);
        }
        catch (IOException e) {
            log.error("No se pudo cargar el documento PDF.", (Throwable)e);
            throw new CustomException("No se pudo cargar el documento PDF.", HttpStatus.INTERNAL_SERVER_ERROR);
        }
        try {
            String base64Output;
            PDPageTree pages = document.getPages();
            for (PDPage page : pages) {
                float height;
                PDRectangle mediaBox = page.getMediaBox();
                float width = mediaBox.getWidth();
                if (!(width > (height = mediaBox.getHeight()))) continue;
                PDPageContentStream contentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.PREPEND, true, true);
                contentStream.transform(new Matrix(0.0f, -1.0f, 1.0f, 0.0f, 0.0f, width));
                contentStream.close();
                PDRectangle rotatedMediaBox = new PDRectangle(height, width);
                page.setMediaBox(rotatedMediaBox);
            }
            String uuidDoocument = UUID.randomUUID().toString();
            String docName = uuidDoocument.concat("-documento_rotado.pdf");
            String outputFilePath = rootPath.concat(docName);
            File outputFile = new File(outputFilePath);
            File outputDirectory = outputFile.getParentFile();
            if (!outputDirectory.exists() && !outputDirectory.mkdirs()) {
                throw new CustomException("No se pudo crear el directorio para guardar el documento.", HttpStatus.INTERNAL_SERVER_ERROR);
            }
            document.save(new File(outputFilePath));
            try {
                byte[] fileContent = Files.readAllBytes(new File(outputFilePath).toPath());
                base64Output = Base64.getEncoder().encodeToString(fileContent);
            }
            catch (IOException e) {
                throw new CustomException("Error al convertir el documento PDF a Base64.", HttpStatus.INTERNAL_SERVER_ERROR);
            }
            try {
                Files.deleteIfExists(new File(outputFilePath).toPath());
            }
            catch (IOException e) {
                log.error("Error al eliminar el archivo PDF: {}", (Object)outputFilePath, (Object)e);
            }
            String string = base64Output;
            return string;
        }
        catch (IOException e) {
            log.error("Error al rotar las p\u00e1ginas del documento PDF", (Throwable)e);
            throw new CustomException("Error al rotar las p\u00e1ginas del documento PDF", HttpStatus.INTERNAL_SERVER_ERROR);
        }
        finally {
            try {
                if (document != null) {
                    log.warn("DOCUMENT CLOSED");
                    document.close();
                }
            }
            catch (IOException e) {
                log.error("Error al cerrar el documento PDF.", (Throwable)e);
            }
        }
    }
}

