/*
 * Decompiled with CFR 0.152.
 */
package com.firma.logic.service.impl;

import com.firma.exceptions.CustomException;
import com.firma.logic.service.AutenticationService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.stereotype.Service;

@Service
public class AutenticationServiceImpl
implements AutenticationService {
    private static final Logger log = LoggerFactory.getLogger(AutenticationServiceImpl.class);
    private final JwtDecoder jwtDecoder;

    public String getMyParameter(String param) {
        log.info("Extrayendo el param: {}", (Object)param);
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        log.info("auth: {}", (Object)authentication);
        log.info("instancia: " + (authentication instanceof JwtAuthenticationToken));
        if (authentication instanceof JwtAuthenticationToken) {
            Jwt jwt = (Jwt)((JwtAuthenticationToken)authentication).getToken();
            log.info("jwt: {}", (Object)jwt);
            String stringParam = (String)jwt.getClaim(param);
            return stringParam;
        }
        return null;
    }

    public Boolean hasRole(String role) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof JwtAuthenticationToken) {
            List accountRoles;
            Map account;
            List roles;
            Jwt jwt = (Jwt)((JwtAuthenticationToken)authentication).getToken();
            Map realmAccess = (Map)jwt.getClaim("realm_access");
            if (realmAccess != null && (roles = (List)realmAccess.get("roles")) != null && roles.contains(role)) {
                return true;
            }
            Map resourceAccess = (Map)jwt.getClaim("resource_access");
            if (resourceAccess != null && (account = (Map)resourceAccess.get("account")) != null && (accountRoles = (List)account.get("roles")) != null && accountRoles.contains(role)) {
                return true;
            }
        }
        return false;
    }

    public String extractJtiFromToken(String token) {
        Jwt jwt = this.jwtDecoder.decode(token);
        String jti = jwt.getId();
        if (jti == null) {
            throw new CustomException("Error al autenticar, consultar al administrador", HttpStatus.BAD_REQUEST);
        }
        return jti;
    }

    public AutenticationServiceImpl(JwtDecoder jwtDecoder) {
        this.jwtDecoder = jwtDecoder;
    }
}

