/*
 * Decompiled with CFR 0.152.
 */
package com.firma.logic.service;

import com.firma.logic.entity.TClientesNotificados;
import com.firma.logic.entity.vistas.BiometriaNotifyModelDTO;
import com.firma.logic.entity.vistas.FirmaNotifyModelDTO;
import com.firma.logic.repository.CallbackBiometriaDAO;
import com.firma.logic.repository.CallbackFirmaDAO;
import com.firma.logic.repository.ClientesNotificadosDAO;
import com.firma.logic.service.NotificacionService;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class AutoTaskNotifies {
    private static final Logger log = LoggerFactory.getLogger(AutoTaskNotifies.class);
    private final Environment env;
    private final ClientesNotificadosDAO clientesNotificadosDAO;
    private final CallbackBiometriaDAO callbackBiometriaDAO;
    private final CallbackFirmaDAO callbackFirmaDAO;
    private final NotificacionService notificacionService;

    public void findNotNotifiesRecived() {
        String maxIntentsString = this.env.getProperty("tws.sendnotifications.intents");
        String lastMinutesString = this.env.getProperty("tws.sendnotifications.lastminutes");
        String tipoBiometria = this.env.getProperty("tws.tipotrans.bio");
        String tipoFirma = this.env.getProperty("tws.tipotrans.fir");
        Integer maxIntents = Integer.parseInt(maxIntentsString);
        Long lastMinutes = Long.parseLong(lastMinutesString);
        LocalDateTime fechaMinusMunitesConfig = LocalDateTime.now().minusMinutes(lastMinutes);
        Long countedNotSentNotifications = this.clientesNotificadosDAO.countOnLastMinutesNotificationsNotSent(fechaMinusMunitesConfig, maxIntents);
        log.info("EXISTE " + countedNotSentNotifications + " NOTIFICACIONES NO ENVIADAS EN LOS ULTIMOS " + lastMinutes + " MINUTOS");
        if (countedNotSentNotifications > 0L) {
            List notSentNotificatios = this.clientesNotificadosDAO.getNotSentNotifications(fechaMinusMunitesConfig, maxIntents);
            for (TClientesNotificados noti : notSentNotificatios) {
                if (noti.getTipoProceso().equals(tipoFirma)) {
                    try {
                        FirmaNotifyModelDTO firmaDTO = this.callbackFirmaDAO.getCallbackFirmaByCode(noti.getCodigoTransaccion());
                        this.notificacionService.notificarFirmaFromAutoTask(firmaDTO.getStatus().intValue(), firmaDTO.getCodigo(), firmaDTO.getTipo());
                        this.notificacionService.updateCounterNotification(firmaDTO.getCodigo(), tipoFirma);
                        log.info("NOTIFICADO {}", (Object)firmaDTO);
                    }
                    catch (Exception e) {
                        log.error("ERROR AL NOTIFICAR LA FIRMA CON LA TAREA AUTOMATICA", (Throwable)e);
                    }
                }
                if (!noti.getTipoProceso().equals(tipoBiometria)) continue;
                try {
                    BiometriaNotifyModelDTO biometriaDTO = this.callbackBiometriaDAO.getBiometria4NotifyByCode(noti.getCodigoTransaccion());
                    this.notificacionService.notificarBiometriaFromAutoTask(biometriaDTO.getStatus().intValue(), biometriaDTO.getCodigo(), biometriaDTO.getRostroSimilitud(), biometriaDTO.getRostroSimilitudFrontal(), biometriaDTO.getRostroSimilitudSelfie());
                    this.notificacionService.updateCounterNotification(biometriaDTO.getCodigo(), tipoBiometria);
                    log.info("NOTIFICADO {}", (Object)biometriaDTO);
                }
                catch (Exception e) {
                    log.error("ERROR AL NOTIFICAR LA BIOMETRIA CON LA TAREA AUTOMATICA", (Throwable)e);
                }
            }
        }
    }

    public AutoTaskNotifies(Environment env, ClientesNotificadosDAO clientesNotificadosDAO, CallbackBiometriaDAO callbackBiometriaDAO, CallbackFirmaDAO callbackFirmaDAO, NotificacionService notificacionService) {
        this.env = env;
        this.clientesNotificadosDAO = clientesNotificadosDAO;
        this.callbackBiometriaDAO = callbackBiometriaDAO;
        this.callbackFirmaDAO = callbackFirmaDAO;
        this.notificacionService = notificacionService;
    }
}

