/*
 * Decompiled with CFR 0.152.
 */
package com.backagrotacartera.logic.service.impl;

import com.backagrotacartera.external.api.ApiService;
import com.backagrotacartera.logic.model.Cliente;
import com.backagrotacartera.logic.model.Factura;
import com.backagrotacartera.logic.repository.ClienteDAO;
import com.backagrotacartera.logic.repository.FacturaDAO;
import com.backagrotacartera.logic.service.FacturaService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class FacturaServiceImpl
implements FacturaService {
    private static final Logger log = LoggerFactory.getLogger(FacturaServiceImpl.class);
    private final ClienteDAO clienteDAO;
    private final TaskExecutor facturaTaskExecutor;
    private final FacturaDAO facturaDAO;
    private final ApiService apiService;

    public ResponseEntity<?> saveAllFacturas(String usuarioEmpleado) {
        List clientes = this.clienteDAO.findAllCodeClients(usuarioEmpleado);
        List<CompletableFuture> futures = clientes.stream().map(codigoCliente -> CompletableFuture.supplyAsync(() -> this.obtenerFacturasPorCodigoCliente(codigoCliente, usuarioEmpleado), (Executor)this.facturaTaskExecutor)).collect(Collectors.toList());
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        List clientesConFacturas = futures.stream().map(CompletableFuture::join).collect(Collectors.toList());
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("status", "OK");
        response.put("data", clientesConFacturas);
        return ResponseEntity.ok(response);
    }

    private Map<String, Object> obtenerFacturasPorCodigoCliente(String codigoCliente, String usuarioEmpleado) {
        this.facturaDAO.deleteByCodigoCliente(codigoCliente);
        String path = "/api/ClienteCartera/byCodigoCliente/" + codigoCliente;
        List facturas = this.apiService.getRequestByParams(path, "CodigoVendedor", usuarioEmpleado);
        Cliente cliente = this.clienteDAO.findByClientByCode(codigoCliente);
        List<Factura> facturasNuevas = facturas.stream().filter(factura -> !this.facturaDAO.existsByNumeroFactura(factura.getNumeroFactura())).collect(Collectors.toList());
        facturasNuevas.forEach(factura -> factura.setCliente(new Cliente(cliente.getIdCliente(), cliente.getCodigoCliente())));
        if (!facturasNuevas.isEmpty()) {
            this.facturaDAO.saveAll(facturasNuevas);
        }
        HashMap<String, Object> clienteData = new HashMap<String, Object>();
        clienteData.put("idCliente", cliente.getIdCliente());
        clienteData.put("codigoCliente", cliente.getCodigoCliente());
        clienteData.put("nombreUsuarioEmpleado", usuarioEmpleado);
        clienteData.put("facturas", facturasNuevas);
        return clienteData;
    }

    public ResponseEntity<?> obtenerTopClientesMes(String nombreUsuarioEmpleado, int topN) {
        List topClientes = this.clienteDAO.findTopClientesMes(nombreUsuarioEmpleado, topN);
        List topClientes2 = this.clienteDAO.findTopClientesMes(nombreUsuarioEmpleado, topN);
        log.info("Data de facturas", (Object)topClientes2.toString());
        return ResponseEntity.ok((Object)topClientes);
    }

    public ResponseEntity<?> obtenerTopClientesTotal(String nombreUsuarioEmpleado, int topN) {
        List topClientes = this.clienteDAO.findTopClientesTotal(nombreUsuarioEmpleado, topN);
        List topClientes2 = this.clienteDAO.findTopClientesTotal(nombreUsuarioEmpleado, topN);
        log.info("Data de facturas totalizado", (Object)topClientes2.toString());
        return ResponseEntity.ok((Object)topClientes);
    }

    public FacturaServiceImpl(ClienteDAO clienteDAO, TaskExecutor facturaTaskExecutor, FacturaDAO facturaDAO, ApiService apiService) {
        this.clienteDAO = clienteDAO;
        this.facturaTaskExecutor = facturaTaskExecutor;
        this.facturaDAO = facturaDAO;
        this.apiService = apiService;
    }
}

