/*
 * Decompiled with CFR 0.152.
 */
package com.backagrotacartera.logic.service.impl;

import com.backagrotacartera.external.api.ApiService;
import com.backagrotacartera.logic.model.Empleado;
import com.backagrotacartera.logic.repository.EmpleadoDAO;
import com.backagrotacartera.logic.service.EmpleadoService;
import com.backagrotacartera.utils.ApiResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.transaction.Transactional;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class EmpleadoServiceImpl
implements EmpleadoService {
    private static final Logger log = LoggerFactory.getLogger(EmpleadoServiceImpl.class);
    private static final String ENDPOINT = "/api/Empleado";
    @Autowired
    private ApiService apiService;
    @Autowired
    private EmpleadoDAO empleadoDAO;

    public ResponseEntity<?> saveEmployee(Empleado empleado) {
        throw new UnsupportedOperationException("Unimplemented method 'saveAllEmployees'");
    }

    @Transactional
    public ResponseEntity<?> saveAllEmployees() {
        try {
            String empleadosJson = this.apiService.getRequest(ENDPOINT);
            log.info("Response JSON: {}", (Object)empleadosJson);
            ObjectMapper objectMapper = new ObjectMapper();
            List empleados = (List)objectMapper.readValue(empleadosJson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            log.info("Empleados: {}", (Object)empleados);
            this.empleadoDAO.saveAll((Iterable)empleados);
            return new ResponseEntity((Object)ApiResponse.ok((Object)"finalizado", (boolean)false), (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            log.error("Error al procesar los empleados", (Throwable)e);
            return new ResponseEntity((Object)ApiResponse.error((int)303, (String)"Error al guardar empleados"), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

