/*
 * Decompiled with CFR 0.152.
 */
package com.backagrotacartera.logic.service.impl;

import com.backagrotacartera.external.api.ApiService;
import com.backagrotacartera.logic.model.Empleado;
import com.backagrotacartera.logic.repository.ClienteDAO;
import com.backagrotacartera.logic.repository.EmpleadoDAO;
import com.backagrotacartera.logic.repository.FacturaDAO;
import com.backagrotacartera.logic.service.ClienteService;
import com.backagrotacartera.logic.service.FacturaService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class ClienteServiceImpl
implements ClienteService {
    private static final Logger log = LoggerFactory.getLogger(ClienteServiceImpl.class);
    private final EmpleadoDAO empleadoDAO;
    private final ClienteDAO clienteDAO;
    private final ApiService apiService;
    private final FacturaDAO facturaDAO;
    @Autowired
    private FacturaService facturaService;

    public ResponseEntity<?> saveAllClients(String employeeUser) {
        this.facturaDAO.deleteAllFacturasByEmpleado(employeeUser);
        this.clienteDAO.deleteAllClientesByEmpleado(employeeUser);
        Optional optionalEmpleado = this.empleadoDAO.findByNombreUsuarioEmpleado(employeeUser);
        if (optionalEmpleado.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(Collections.singletonMap("message", "Empleado no encontrado"));
        }
        Empleado empleado = (Empleado)optionalEmpleado.get();
        Map empleadoData = this.obtenerClientesPorEmpleado(empleado);
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("status", "OK");
        response.put("data", empleadoData);
        return ResponseEntity.ok(response);
    }

    private Map<String, Object> obtenerClientesPorEmpleado(Empleado empleado) {
        String path = "api/ClienteVendedor/byPalabra/";
        List clientes = this.apiService.getRequestByParams(path, empleado.getNombreUsuarioEmpleado());
        clientes.forEach(cliente -> cliente.setEmpleado(empleado));
        List clientesNuevos = clientes.stream().filter(cliente -> !this.clienteDAO.existsByCodigoCliente(cliente.getCodigoCliente())).collect(Collectors.toList());
        if (!clientesNuevos.isEmpty()) {
            this.clienteDAO.saveAll(clientesNuevos);
        }
        this.facturaService.saveAllFacturas(empleado.getNombreUsuarioEmpleado());
        HashMap<String, Object> empleadoData = new HashMap<String, Object>();
        empleadoData.put("idEmpleado", empleado.getId());
        empleadoData.put("nombreUsuarioEmpleado", empleado.getNombreUsuarioEmpleado());
        empleadoData.put("clientes", clientesNuevos);
        return empleadoData;
    }

    public ClienteServiceImpl(EmpleadoDAO empleadoDAO, ClienteDAO clienteDAO, ApiService apiService, FacturaDAO facturaDAO, FacturaService facturaService) {
        this.empleadoDAO = empleadoDAO;
        this.clienteDAO = clienteDAO;
        this.apiService = apiService;
        this.facturaDAO = facturaDAO;
        this.facturaService = facturaService;
    }
}

