/*
 * Decompiled with CFR 0.152.
 */
package com.backagrotacartera.logic.repository;

import com.backagrotacartera.logic.model.Factura;
import jakarta.transaction.Transactional;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface FacturaDAO
extends JpaRepository<Factura, Long> {
    public boolean existsByNumeroFactura(String var1);

    @Transactional
    default public void saveAllInBatch(List<Factura> facturas) {
        this.saveAllAndFlush(facturas);
    }

    @Transactional
    @Modifying
    @Query(value="DELETE FROM Factura f WHERE f.cliente.codigoCliente = :codigoCliente")
    public void deleteByCodigoCliente(@Param(value="codigoCliente") String var1);

    @Modifying
    @Transactional
    @Query(value="DELETE FROM Factura f WHERE f.cliente.idCliente IN (SELECT c.idCliente FROM Cliente c WHERE c.nombreUsuarioEmpleado = :employeeUser)")
    public void deleteAllFacturasByEmpleado(@Param(value="employeeUser") String var1);
}

