/*
 * Decompiled with CFR 0.152.
 */
package com.backagrotacartera.logic.repository;

import com.backagrotacartera.logic.data.dto.ClienteCarteraMesDTO;
import com.backagrotacartera.logic.data.dto.ClienteCarteraTotalDTO;
import com.backagrotacartera.logic.model.Cliente;
import jakarta.transaction.Transactional;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ClienteDAO
extends JpaRepository<Cliente, String> {
    @Query(value="SELECT c.codigoCliente FROM Cliente c where c.empleado.nombreUsuarioEmpleado = :codigoVendedor")
    public List<String> findAllCodeClients(String var1);

    @Query(value="SELECT c.codigoCliente FROM Cliente c WHERE c.codigoCliente = :codigo_cliente AND c.empleado.nombreUsuarioEmpleado = :CodigoVendedor")
    public Optional<Cliente> findByCodigoCliente(String var1, String var2);

    @Query(value="SELECT c FROM Cliente c WHERE c.codigoCliente = :codigo_cliente ")
    public Cliente findByClientByCode(String var1);

    public boolean existsByCodigoCliente(String var1);

    @Query(value="SELECT * FROM public.vw_top_clientes_mes WHERE nombre_usuario_empleado = :nombreUsuarioEmpleado ORDER BY cartera DESC LIMIT :topN", nativeQuery=true)
    public List<ClienteCarteraMesDTO> findTopClientesMes(@Param(value="nombreUsuarioEmpleado") String var1, @Param(value="topN") int var2);

    @Query(value="SELECT * FROM public.vw_top_clientes_total WHERE nombre_usuario_empleado = :nombreUsuarioEmpleado ORDER BY cartera DESC LIMIT :topN", nativeQuery=true)
    public List<ClienteCarteraTotalDTO> findTopClientesTotal(@Param(value="nombreUsuarioEmpleado") String var1, @Param(value="topN") int var2);

    @Modifying
    @Transactional
    @Query(value="DELETE FROM Cliente c WHERE c.nombreUsuarioEmpleado = :employeeUser")
    public void deleteAllClientesByEmpleado(@Param(value="employeeUser") String var1);
}

