/*
 * Decompiled with CFR 0.152.
 */
package com.backagrotacartera.logic.model;

import com.backagrotacartera.logic.model.Cliente;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;

@Entity
@Table(name="facturas")
public class Factura {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_factura")
    private Long id;
    @JsonProperty(value="factura")
    @Column(name="numero_factura", nullable=false)
    private String numeroFactura;
    @JsonProperty(value="n_Cuota")
    @Column(name="numero_cuota", nullable=false)
    private Integer numeroCuota;
    @JsonProperty(value="saldo")
    @Column(name="saldo", nullable=false)
    private Double saldo;
    @JsonProperty(value="fechaEmision")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="MM/dd/yyyy HH:mm:ss", timezone="America/Guayaquil")
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="fecha_emision", nullable=false)
    private Date fechaEmision;
    @JsonProperty(value="fechaVencimiento")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="MM/dd/yyyy HH:mm:ss", timezone="America/Guayaquil")
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="fecha_vencimiento", nullable=false)
    private Date fechaVencimiento;
    @JsonProperty(value="diasVencimiento")
    @Column(name="dias_vencimiento", nullable=false)
    private String diasVencimiento;
    @JsonProperty(value="saldovencido")
    @Column(name="saldo_vencido", nullable=false)
    private Double saldoVencido;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="id_cliente", nullable=false)
    private Cliente cliente;

    public Factura(Long id, String numeroFactura, Integer numeroCuota, Double saldo, Date fechaEmision, Date fechaVencimiento, String diasVencimiento, Double saldoVencido, Cliente cliente) {
        this.id = id;
        this.numeroFactura = numeroFactura;
        this.numeroCuota = numeroCuota;
        this.saldo = saldo;
        this.fechaEmision = fechaEmision;
        this.fechaVencimiento = fechaVencimiento;
        this.diasVencimiento = diasVencimiento;
        this.saldoVencido = saldoVencido;
        this.cliente = cliente;
    }

    public Factura() {
    }

    public Long getId() {
        return this.id;
    }

    public String getNumeroFactura() {
        return this.numeroFactura;
    }

    public Integer getNumeroCuota() {
        return this.numeroCuota;
    }

    public Double getSaldo() {
        return this.saldo;
    }

    public Date getFechaEmision() {
        return this.fechaEmision;
    }

    public Date getFechaVencimiento() {
        return this.fechaVencimiento;
    }

    public String getDiasVencimiento() {
        return this.diasVencimiento;
    }

    public Double getSaldoVencido() {
        return this.saldoVencido;
    }

    public Cliente getCliente() {
        return this.cliente;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty(value="factura")
    public void setNumeroFactura(String numeroFactura) {
        this.numeroFactura = numeroFactura;
    }

    @JsonProperty(value="n_Cuota")
    public void setNumeroCuota(Integer numeroCuota) {
        this.numeroCuota = numeroCuota;
    }

    @JsonProperty(value="saldo")
    public void setSaldo(Double saldo) {
        this.saldo = saldo;
    }

    @JsonProperty(value="fechaEmision")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="MM/dd/yyyy HH:mm:ss", timezone="America/Guayaquil")
    public void setFechaEmision(Date fechaEmision) {
        this.fechaEmision = fechaEmision;
    }

    @JsonProperty(value="fechaVencimiento")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="MM/dd/yyyy HH:mm:ss", timezone="America/Guayaquil")
    public void setFechaVencimiento(Date fechaVencimiento) {
        this.fechaVencimiento = fechaVencimiento;
    }

    @JsonProperty(value="diasVencimiento")
    public void setDiasVencimiento(String diasVencimiento) {
        this.diasVencimiento = diasVencimiento;
    }

    @JsonProperty(value="saldovencido")
    public void setSaldoVencido(Double saldoVencido) {
        this.saldoVencido = saldoVencido;
    }

    @JsonIgnore
    public void setCliente(Cliente cliente) {
        this.cliente = cliente;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Factura)) {
            return false;
        }
        Factura other = (Factura)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$numeroCuota = this.getNumeroCuota();
        Integer other$numeroCuota = other.getNumeroCuota();
        if (this$numeroCuota == null ? other$numeroCuota != null : !((Object)this$numeroCuota).equals(other$numeroCuota)) {
            return false;
        }
        Double this$saldo = this.getSaldo();
        Double other$saldo = other.getSaldo();
        if (this$saldo == null ? other$saldo != null : !((Object)this$saldo).equals(other$saldo)) {
            return false;
        }
        Double this$saldoVencido = this.getSaldoVencido();
        Double other$saldoVencido = other.getSaldoVencido();
        if (this$saldoVencido == null ? other$saldoVencido != null : !((Object)this$saldoVencido).equals(other$saldoVencido)) {
            return false;
        }
        String this$numeroFactura = this.getNumeroFactura();
        String other$numeroFactura = other.getNumeroFactura();
        if (this$numeroFactura == null ? other$numeroFactura != null : !this$numeroFactura.equals(other$numeroFactura)) {
            return false;
        }
        Date this$fechaEmision = this.getFechaEmision();
        Date other$fechaEmision = other.getFechaEmision();
        if (this$fechaEmision == null ? other$fechaEmision != null : !((Object)this$fechaEmision).equals(other$fechaEmision)) {
            return false;
        }
        Date this$fechaVencimiento = this.getFechaVencimiento();
        Date other$fechaVencimiento = other.getFechaVencimiento();
        if (this$fechaVencimiento == null ? other$fechaVencimiento != null : !((Object)this$fechaVencimiento).equals(other$fechaVencimiento)) {
            return false;
        }
        String this$diasVencimiento = this.getDiasVencimiento();
        String other$diasVencimiento = other.getDiasVencimiento();
        if (this$diasVencimiento == null ? other$diasVencimiento != null : !this$diasVencimiento.equals(other$diasVencimiento)) {
            return false;
        }
        Cliente this$cliente = this.getCliente();
        Cliente other$cliente = other.getCliente();
        return !(this$cliente == null ? other$cliente != null : !this$cliente.equals(other$cliente));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Factura;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $numeroCuota = this.getNumeroCuota();
        result = result * 59 + ($numeroCuota == null ? 43 : ((Object)$numeroCuota).hashCode());
        Double $saldo = this.getSaldo();
        result = result * 59 + ($saldo == null ? 43 : ((Object)$saldo).hashCode());
        Double $saldoVencido = this.getSaldoVencido();
        result = result * 59 + ($saldoVencido == null ? 43 : ((Object)$saldoVencido).hashCode());
        String $numeroFactura = this.getNumeroFactura();
        result = result * 59 + ($numeroFactura == null ? 43 : $numeroFactura.hashCode());
        Date $fechaEmision = this.getFechaEmision();
        result = result * 59 + ($fechaEmision == null ? 43 : ((Object)$fechaEmision).hashCode());
        Date $fechaVencimiento = this.getFechaVencimiento();
        result = result * 59 + ($fechaVencimiento == null ? 43 : ((Object)$fechaVencimiento).hashCode());
        String $diasVencimiento = this.getDiasVencimiento();
        result = result * 59 + ($diasVencimiento == null ? 43 : $diasVencimiento.hashCode());
        Cliente $cliente = this.getCliente();
        result = result * 59 + ($cliente == null ? 43 : $cliente.hashCode());
        return result;
    }

    public String toString() {
        return "Factura(id=" + this.getId() + ", numeroFactura=" + this.getNumeroFactura() + ", numeroCuota=" + this.getNumeroCuota() + ", saldo=" + this.getSaldo() + ", fechaEmision=" + String.valueOf(this.getFechaEmision()) + ", fechaVencimiento=" + String.valueOf(this.getFechaVencimiento()) + ", diasVencimiento=" + this.getDiasVencimiento() + ", saldoVencido=" + this.getSaldoVencido() + ", cliente=" + String.valueOf(this.getCliente()) + ")";
    }
}

