/*
 * Decompiled with CFR 0.152.
 */
package com.backagrotacartera.logic.model;

import com.backagrotacartera.logic.model.Cliente;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.List;

@Entity
@Table(name="empleados")
public class Empleado {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="cedula_empleado", nullable=false, unique=true)
    private String cedulaEmpleado;
    @Column(name="nombre_usuario_empleado", nullable=false, unique=true)
    private String nombreUsuarioEmpleado;
    @Column(name="nombre_completo", nullable=true)
    private String apellidosNombresEmpleado;
    @JsonIgnore
    @OneToMany(mappedBy="empleado", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Cliente> clientes;

    public Empleado(Long id, String cedulaEmpleado, String nombreUsuarioEmpleado, String apellidosNombresEmpleado, List<Cliente> clientes) {
        this.id = id;
        this.cedulaEmpleado = cedulaEmpleado;
        this.nombreUsuarioEmpleado = nombreUsuarioEmpleado;
        this.apellidosNombresEmpleado = apellidosNombresEmpleado;
        this.clientes = clientes;
    }

    public Empleado() {
    }

    public Long getId() {
        return this.id;
    }

    public String getCedulaEmpleado() {
        return this.cedulaEmpleado;
    }

    public String getNombreUsuarioEmpleado() {
        return this.nombreUsuarioEmpleado;
    }

    public String getApellidosNombresEmpleado() {
        return this.apellidosNombresEmpleado;
    }

    public List<Cliente> getClientes() {
        return this.clientes;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCedulaEmpleado(String cedulaEmpleado) {
        this.cedulaEmpleado = cedulaEmpleado;
    }

    public void setNombreUsuarioEmpleado(String nombreUsuarioEmpleado) {
        this.nombreUsuarioEmpleado = nombreUsuarioEmpleado;
    }

    public void setApellidosNombresEmpleado(String apellidosNombresEmpleado) {
        this.apellidosNombresEmpleado = apellidosNombresEmpleado;
    }

    @JsonIgnore
    public void setClientes(List<Cliente> clientes) {
        this.clientes = clientes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Empleado)) {
            return false;
        }
        Empleado other = (Empleado)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$cedulaEmpleado = this.getCedulaEmpleado();
        String other$cedulaEmpleado = other.getCedulaEmpleado();
        if (this$cedulaEmpleado == null ? other$cedulaEmpleado != null : !this$cedulaEmpleado.equals(other$cedulaEmpleado)) {
            return false;
        }
        String this$nombreUsuarioEmpleado = this.getNombreUsuarioEmpleado();
        String other$nombreUsuarioEmpleado = other.getNombreUsuarioEmpleado();
        if (this$nombreUsuarioEmpleado == null ? other$nombreUsuarioEmpleado != null : !this$nombreUsuarioEmpleado.equals(other$nombreUsuarioEmpleado)) {
            return false;
        }
        String this$apellidosNombresEmpleado = this.getApellidosNombresEmpleado();
        String other$apellidosNombresEmpleado = other.getApellidosNombresEmpleado();
        if (this$apellidosNombresEmpleado == null ? other$apellidosNombresEmpleado != null : !this$apellidosNombresEmpleado.equals(other$apellidosNombresEmpleado)) {
            return false;
        }
        List this$clientes = this.getClientes();
        List other$clientes = other.getClientes();
        return !(this$clientes == null ? other$clientes != null : !((Object)this$clientes).equals(other$clientes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Empleado;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $cedulaEmpleado = this.getCedulaEmpleado();
        result = result * 59 + ($cedulaEmpleado == null ? 43 : $cedulaEmpleado.hashCode());
        String $nombreUsuarioEmpleado = this.getNombreUsuarioEmpleado();
        result = result * 59 + ($nombreUsuarioEmpleado == null ? 43 : $nombreUsuarioEmpleado.hashCode());
        String $apellidosNombresEmpleado = this.getApellidosNombresEmpleado();
        result = result * 59 + ($apellidosNombresEmpleado == null ? 43 : $apellidosNombresEmpleado.hashCode());
        List $clientes = this.getClientes();
        result = result * 59 + ($clientes == null ? 43 : ((Object)$clientes).hashCode());
        return result;
    }

    public String toString() {
        return "Empleado(id=" + this.getId() + ", cedulaEmpleado=" + this.getCedulaEmpleado() + ", nombreUsuarioEmpleado=" + this.getNombreUsuarioEmpleado() + ", apellidosNombresEmpleado=" + this.getApellidosNombresEmpleado() + ", clientes=" + String.valueOf(this.getClientes()) + ")";
    }
}

