/*
 * Decompiled with CFR 0.152.
 */
package com.backagrotacartera.logic.controller;

import com.backagrotacartera.logic.service.ClienteService;
import com.backagrotacartera.logic.service.EmpleadoService;
import com.backagrotacartera.logic.service.FacturaService;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"v1/allApis"})
public class CarteraController {
    private final EmpleadoService empleadoService;
    private final ClienteService clienteService;
    private final FacturaService facturaService;

    @PostMapping(value={"/saveAllEmployees"})
    public ResponseEntity<?> saveAllEmployees() {
        return this.empleadoService.saveAllEmployees();
    }

    @PostMapping(value={"/saveAllClients"})
    public ResponseEntity<?> saveAllClientsByEmployeeUser(@RequestParam(value="employeeUser") String employeeUser) {
        return this.clienteService.saveAllClients(employeeUser);
    }

    @GetMapping(value={"/top-clientes-mes"})
    public ResponseEntity<?> obtenerTopClientesMes(@RequestParam String nombreUsuarioEmpleado, @RequestParam int topN) {
        return this.facturaService.obtenerTopClientesMes(nombreUsuarioEmpleado, topN);
    }

    @GetMapping(value={"/top-clientes-total"})
    public ResponseEntity<?> obtenerTopClientesTotal(@RequestParam String nombreUsuarioEmpleado, @RequestParam int topN) {
        return this.facturaService.obtenerTopClientesTotal(nombreUsuarioEmpleado, topN);
    }

    public CarteraController(EmpleadoService empleadoService, ClienteService clienteService, FacturaService facturaService) {
        this.empleadoService = empleadoService;
        this.clienteService = clienteService;
        this.facturaService = facturaService;
    }
}

