/*
 * Decompiled with CFR 0.152.
 */
package com.backagrotacartera.interceptors;

import com.backagrotacartera.exceptions.CustomException;
import com.backagrotacartera.utils.ApiResponse;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ApiResponse<Object>> handleGlobalException(Exception ex, WebRequest request) {
        log.error("ERROR 'Exception' CAPTURADO", (Throwable)ex);
        ApiResponse response = new ApiResponse(500, false, false, ex.getMessage(), null);
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={RuntimeException.class})
    public ResponseEntity<ApiResponse<Object>> handleGlobalException(RuntimeException ex, WebRequest request) {
        log.error("ERROR 'RuntimeException' CAPTURADO", (Throwable)ex);
        ApiResponse response = new ApiResponse(500, false, false, ex.getMessage(), null);
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={CustomException.class})
    public ResponseEntity<ApiResponse<Object>> handleGlobalException(CustomException ex, WebRequest request) {
        log.error("ERROR 'CustomException' CAPTURADO", (Throwable)ex);
        ApiResponse response = new ApiResponse(ex.getHttpStatus().value(), false, false, ex.getMessage(), null);
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<ApiResponse<Object>> handleValidationExceptions(MethodArgumentNotValidException ex) {
        log.error("ERROR 'MethodArgumentNotValidException' CAPTURADO", (Throwable)ex);
        HashMap errors = new HashMap();
        ex.getBindingResult().getAllErrors().forEach(error -> {
            String fieldName = ((FieldError)error).getField();
            String errorMessage = error.getDefaultMessage();
            errors.put(fieldName, errorMessage);
        });
        ApiResponse response = new ApiResponse(400, false, false, "Error de validaci\u00f3n", errors);
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }
}

