/*
 * Decompiled with CFR 0.152.
 */
package com.backagrotacartera.external.api;

import com.backagrotacartera.external.api.ApiService;
import com.backagrotacartera.external.models.ApiConfig;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class TokenService {
    private static final Logger log = LoggerFactory.getLogger(TokenService.class);
    private final ApiService apiService;
    private String token;
    private final ApiConfig apiConfig;

    public TokenService(@Lazy ApiService apiService, ApiConfig apiConfig) {
        this.apiService = apiService;
        this.apiConfig = apiConfig;
    }

    public String getToken() {
        if (this.token == null || this.token.isEmpty()) {
            this.token = this.authenticate();
        }
        return this.token;
    }

    private String authenticate() {
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("usuario", this.apiConfig.getUsername());
        requestBody.put("clave", this.apiConfig.getPassword());
        String response = this.apiService.postRequest("/api/Autenticacion/Validar", requestBody);
        log.info("Respuesta de autenticaci\u00f3n: {}", (Object)response);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            Map responseMap = (Map)objectMapper.readValue(response, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return (String)responseMap.get("token");
        }
        catch (Exception e) {
            throw new RuntimeException("Error al parsear el token de autenticaci\u00f3n", e);
        }
    }
}

