/*
 * Decompiled with CFR 0.152.
 */
package com.backagrotacartera.external.api;

import com.backagrotacartera.external.api.TokenService;
import com.backagrotacartera.external.models.ApiConfig;
import com.backagrotacartera.logic.model.Cliente;
import com.backagrotacartera.logic.model.Factura;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class ApiService {
    private static final Logger log = LoggerFactory.getLogger(ApiService.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ApiConfig apiConfig;
    @Autowired
    private TokenService authService;

    public ApiService(RestTemplate restTemplate, @Lazy TokenService tokenService) {
        this.restTemplate = restTemplate;
        this.authService = tokenService;
    }

    public String postRequest(String endpoint, Map<String, String> requestBody) {
        HttpHeaders headers = this.createHeaders(null);
        HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
        String url = this.apiConfig.getBaseUrl() + endpoint;
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        return this.handleResponse(response);
    }

    public String getRequest(String endpoint) {
        String token = this.authService.getToken();
        log.info("Token: {}", (Object)token);
        log.info("Endpoint: {}", (Object)endpoint);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + token);
        String url = this.apiConfig.getBaseUrl() + endpoint;
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, request, String.class, new Object[0]);
        return (String)response.getBody();
    }

    public List<Cliente> getRequestByParams(String endpoint, String nombreEmpleado) {
        String token = this.authService.getToken();
        log.info("Token: {}", (Object)token);
        log.info("Endpoint: {}", (Object)endpoint);
        log.info("NombreEmpleado: {}", (Object)nombreEmpleado);
        String nombreCliente = "%";
        String url = UriComponentsBuilder.fromHttpUrl((String)(this.apiConfig.getBaseUrl() + "/api/ClienteVendedor/byPalabra/" + nombreEmpleado)).queryParam("NombreApellidoNombreComercial", new Object[]{nombreCliente}).toUriString();
        log.info("URL final generada: {}", (Object)url);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + token);
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        return (List)response.getBody();
    }

    public List<Factura> getRequestByParams(String endpoint, String queryParamName, String queryParamValue) {
        String token = this.authService.getToken();
        log.info("Token: {}", (Object)token);
        log.info("Endpoint: {}", (Object)endpoint);
        String url = UriComponentsBuilder.fromHttpUrl((String)(this.apiConfig.getBaseUrl() + endpoint)).queryParam(queryParamName, new Object[]{queryParamValue}).toUriString();
        log.info("URL final generada: {}", (Object)url);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + token);
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        return (List)response.getBody();
    }

    private HttpHeaders createHeaders(String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (token != null) {
            headers.set("Authorization", "Bearer " + token);
        }
        return headers;
    }

    private String handleResponse(ResponseEntity<String> response) {
        if (response.getStatusCode().is2xxSuccessful()) {
            return (String)response.getBody();
        }
        throw new RuntimeException("Error en la petici\u00f3n: " + String.valueOf(response.getStatusCode()));
    }
}

