# Prompts Directory

This directory contains AI prompt templates used by the MCP Server for budget analysis and query processing.

## Files

### `dax-transformation.txt`
System prompt for transforming natural language queries into DAX queries for Power BI.

**Includes:**
- Table schemas and relationships
- Budget analysis calculation formulas
- Example DAX queries  
- Best practices for joins and aggregations

**Used by:** `QueryService.transformToSql()`

### `response-summary.txt`
System prompt for generating user-friendly WhatsApp responses from Power BI query results.

**Includes:**
- Budget analysis formatting rules
- KPI interpretation guidelines
- Response templates with examples
- Emoji usage standards

**Used by:** `QueryService.summarizeResponse()`

## Updating Prompts

These files can be edited directly without recompiling the application. Changes will take effect after restarting the MCP Server.

### Best Practices

1. **Test changes gradually** - Make small modifications and test
2. **Keep examples** - Include concrete examples to guide the AI
3. **Be explicit** - Clear instructions produce better results
4. **Use structure** - Headers and sections improve readability

## Related Documentation

- [KNOWLEDGE_BASE_CARTERA.md](../../../docs/KNOWLEDGE_BASE_CARTERA.md) - Detailed credit and portfolio analysis specifications
- [QueryService.java](../../java/agrota/mcpserveragrota/service/QueryService.java) - Implementation using these prompts

## Version

Current version: 1.0  
Last updated: 2026-02-06
