/*
 * Decompiled with CFR 0.152.
 */
package agrota.mcpserveragrota.tool;

import agrota.mcpserveragrota.model.dto.PowerBIQueryResponse;
import agrota.mcpserveragrota.service.BackAgrotaClient;
import agrota.mcpserveragrota.service.QueryService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.stereotype.Component;

@Component
public class AgrotaMcpTools {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AgrotaMcpTools.class);
    private final QueryService queryService;
    private final BackAgrotaClient backAgrotaClient;

    @Tool(description="Transforma una solicitud en lenguaje natural a DAX y consulta el Power BI de Agrota.")
    public String consultarAgrota(String prompt) {
        return this.consultarAgrota(prompt, "", "", "");
    }

    public String consultarAgrota(String prompt, String userName, String userPosition) {
        return this.consultarAgrota(prompt, userName, userPosition, "");
    }

    public String consultarAgrota(String prompt, String userName, String userPosition, String chatHistory) {
        log.info("Recibida solicitud MCP | Usuario: {} ({}) | History length: {}", new Object[]{userName, userPosition, chatHistory != null ? chatHistory.length() : 0});
        String dax = this.queryService.transformToSql(prompt, userName, userPosition, chatHistory);
        log.info("DAX generado para la solicitud: \n{}", (Object)dax);
        if (dax == null || dax.trim().isEmpty()) {
            return "Lo siento, no pude procesar tu solicitud. Prueba preguntarme de otra forma, como '\u00bfCu\u00e1l es la cartera vencida?' \ud83d\udcca";
        }
        if (dax.trim().startsWith("DIRECT_RESPONSE:")) {
            return dax.trim().substring("DIRECT_RESPONSE:".length()).trim();
        }
        if (!this.isLikelyDax(dax)) {
            log.warn("AI returned plain text without prefix: '{}'. Treating as direct response.", (Object)dax);
            return dax;
        }
        try {
            PowerBIQueryResponse response = this.backAgrotaClient.sendQuery(dax);
            log.info("Respuesta recibida de BackAgrota: {}", (Object)response);
            if (response == null) {
                log.error("Respuesta de BackAgrota es null");
                return "Tuve un peque\u00f1o problema t\u00e9cnico al conectar con los datos. \ud83d\udd04 \u00bfPodr\u00edas intentar de nuevo en un momento?";
            }
            if ("success".equals(response.getStatus())) {
                if (response.getResults() == null || response.getResults().isEmpty()) {
                    return "Consulta ejecutada con \u00e9xito, pero no se encontraron resultados para esta b\u00fasqueda en Power BI. \ud83e\uddd0";
                }
                String summary = this.queryService.summarizeResponse(prompt, response.getResults(), userName, userPosition, chatHistory);
                return summary;
            }
            log.error("Error en respuesta de BackAgrota: {}", (Object)response.getError());
            String greeting = userName == null || userName.isEmpty() ? "Lo siento" : "Lo siento " + userName;
            return greeting + ", no logr\u00e9 encontrar el dato exacto en el reporte. \ud83d\udcc8 Prueba preguntando por 'Ventas del mes' o 'Cartera vencida' para guiarme mejor.";
        }
        catch (Exception e) {
            log.error("Error al consultar BackAgrota: {}", (Object)e.getMessage());
            return "En este momento no puedo acceder a los reportes. \ud83d\udee0\ufe0f Pero estoy aqu\u00ed para ayudarte con dudas generales sobre c\u00f3mo usar este asistente.";
        }
    }

    private boolean isLikelyDax(String text) {
        boolean hasDaxKeywords;
        if (text == null || text.trim().isEmpty()) {
            return false;
        }
        String upper = text.toUpperCase();
        if (upper.contains(" SOY LHIA") || upper.contains("HOLA") || upper.contains("AGROTA ES") || upper.contains("PUEDO AYUDAR") || upper.contains("LAMENTO") || upper.contains("CREADA POR")) {
            return false;
        }
        boolean bl = hasDaxKeywords = upper.contains("EVALUATE") || upper.contains("SUMMARIZE") || upper.contains("FILTER(") || upper.contains("CALCULATE(") || upper.contains("SELECTCOLUMNS(") || upper.contains("VAR ") || upper.contains("RETURN");
        if (!hasDaxKeywords && text.contains(" ") && text.length() > 20) {
            return false;
        }
        return hasDaxKeywords;
    }

    @Generated
    public AgrotaMcpTools(QueryService queryService, BackAgrotaClient backAgrotaClient) {
        this.queryService = queryService;
        this.backAgrotaClient = backAgrotaClient;
    }
}

