/*
 * Decompiled with CFR 0.152.
 */
package agrota.mcpserveragrota.service;

import agrota.mcpserveragrota.service.PromptLoaderService;
import io.github.resilience4j.circuitbreaker.annotation.CircuitBreaker;
import io.github.resilience4j.timelimiter.annotation.TimeLimiter;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.stereotype.Service;

@Service
public class QueryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryService.class);
    private final ChatClient chatClient;
    private final PromptLoaderService promptLoader;

    public QueryService(ChatClient.Builder chatClientBuilder, PromptLoaderService promptLoader) {
        this.chatClient = chatClientBuilder.build();
        this.promptLoader = promptLoader;
    }

    @CircuitBreaker(name="default", fallbackMethod="fallbackTransformToSql")
    @TimeLimiter(name="default", fallbackMethod="fallbackTransformToSql")
    public String transformToSql(String text) {
        return this.transformToSql(text, "", "", "");
    }

    public String transformToSql(String text, String userName, String userPosition, String chatHistory) {
        Object systemPrompt = this.promptLoader.getDaxTransformationPrompt();
        StringBuilder userContext = new StringBuilder();
        if (userName != null && !userName.isEmpty()) {
            userContext.append("Usuario actual: ").append(userName).append((String)(userPosition == null || userPosition.isEmpty() ? "" : " (" + userPosition + ")")).append("\n");
        }
        if (chatHistory != null && !chatHistory.trim().isEmpty()) {
            userContext.append("\n=== HISTORIAL DE CONVERSACI\u00d3N RECIENTE ===\n").append("Este es el contexto de los \u00faltimos mensajes. \u00dasalo para entender referencias como 'de qu\u00e9 mes es eso', 'a qu\u00e9 vendedor se refiere', etc:\n").append(chatHistory).append("\n==========================================\n\n");
        }
        if (userContext.length() > 0) {
            systemPrompt = userContext.toString() + (String)systemPrompt;
        }
        log.debug("Using DAX transformation prompt ({} chars)", (Object)((String)systemPrompt).length());
        String dax = this.chatClient.prompt().system((String)systemPrompt).user(text).call().content();
        if (dax != null) {
            if ((dax = dax.trim()).startsWith("```")) {
                dax = dax.replaceFirst("^```(?:dax)?\\s*", "");
                dax = dax.replaceFirst("\\s*```$", "");
            }
            return dax.trim();
        }
        return "";
    }

    public String fallbackTransformToSql(String text, String userName, String userPosition, String chatHistory, Throwable t) {
        log.error("Circuit Breaker fallback for transformToSql: {}", (Object)t.getMessage());
        return "";
    }

    public String fallbackTransformToSql(String text, Throwable t) {
        return this.fallbackTransformToSql(text, "", "", "", t);
    }

    @CircuitBreaker(name="default", fallbackMethod="fallbackSummarizeResponse")
    @TimeLimiter(name="default", fallbackMethod="fallbackSummarizeResponse")
    public String summarizeResponse(String originalPrompt, List<Map<String, Object>> data) {
        return this.summarizeResponse(originalPrompt, data, "", "", "");
    }

    public String summarizeResponse(String originalPrompt, List<Map<String, Object>> data, String userName, String userPosition, String chatHistory) {
        if (data == null || data.isEmpty()) {
            return "No se encontraron datos para responder a la consulta.";
        }
        int limit = 15;
        List<Map<String, Object>> limitedData = data.size() > limit ? data.subList(0, limit) : data;
        String dataString = limitedData.toString();
        Object systemPrompt = this.promptLoader.getResponseSummaryPrompt();
        StringBuilder userContext = new StringBuilder();
        if (userName != null && !userName.isEmpty()) {
            userContext.append("Te diriges a: ").append(userName).append((String)(userPosition == null || userPosition.isEmpty() ? "" : " (" + userPosition + ")")).append("\n");
        }
        if (chatHistory != null && !chatHistory.trim().isEmpty()) {
            userContext.append("\nHistorial (para dar contexto a la respuesta, no lo resumas todo, solo responde a la pregunta actual en base a los datos):\n").append(chatHistory).append("\n\n");
        }
        if (userContext.length() > 0) {
            systemPrompt = userContext.toString() + (String)systemPrompt;
        }
        log.debug("Using response summary prompt ({} chars)", (Object)((String)systemPrompt).length());
        return this.chatClient.prompt().system((String)systemPrompt).user(u -> u.text("Consulta del usuario: {prompt}\n\nDatos de Power BI: {data}").param("prompt", (Object)originalPrompt).param("data", (Object)dataString)).call().content();
    }

    public String fallbackSummarizeResponse(String originalPrompt, List<Map<String, Object>> data, String userName, String userPosition, String chatHistory, Throwable t) {
        log.error("Circuit Breaker fallback for summarizeResponse: {}", (Object)t.getMessage());
        return "Lo siento " + (String)(userName == null || userName.isEmpty() ? "" : userName + ",") + " no puedo procesar tu solicitud en este momento.";
    }

    public String fallbackSummarizeResponse(String originalPrompt, List<Map<String, Object>> data, Throwable t) {
        return this.fallbackSummarizeResponse(originalPrompt, data, "", "", "", t);
    }
}

