/*
 * Decompiled with CFR 0.152.
 */
package agrota.mcpserveragrota.service;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.util.StreamUtils;

@Service
public class PromptLoaderService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PromptLoaderService.class);
    private static final String PROMPT_DIR = "prompts/";

    public String loadPrompt(String filename) {
        try {
            ClassPathResource resource = new ClassPathResource(PROMPT_DIR + filename);
            String content = StreamUtils.copyToString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
            log.debug("Loaded prompt from: {}", (Object)filename);
            return content;
        }
        catch (IOException e) {
            log.error("Failed to load prompt file: {}", (Object)filename, (Object)e);
            throw new RuntimeException("Could not load prompt file: " + filename, e);
        }
    }

    public String getDaxTransformationPrompt() {
        return this.loadPrompt("dax-transformation.txt");
    }

    public String getResponseSummaryPrompt() {
        return this.loadPrompt("response-summary.txt");
    }
}

