/*
 * Decompiled with CFR 0.152.
 */
package agrota.mcpserveragrota.service;

import agrota.mcpserveragrota.model.dto.KeycloakTokenResponse;
import io.github.resilience4j.circuitbreaker.annotation.CircuitBreaker;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestClient;

@Service
public class KeycloakService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KeycloakService.class);
    private final RestClient restClient;
    @Value(value="${auth.login.url}")
    private String loginUrl;
    @Value(value="${auth.username}")
    private String username;
    @Value(value="${auth.password}")
    private String password;
    @Value(value="${auth.client-id}")
    private String clientId;
    @Value(value="${auth.grant-type}")
    private String grantType;
    private String cachedToken;
    private long expirationTime;

    public String getAccessToken() {
        return this.getAccessToken(false);
    }

    @CircuitBreaker(name="default", fallbackMethod="fallbackGetAccessToken")
    public synchronized String getAccessToken(boolean forceRefresh) {
        if (!forceRefresh && this.cachedToken != null && System.currentTimeMillis() < this.expirationTime) {
            return this.cachedToken;
        }
        try {
            LinkedMultiValueMap formData = new LinkedMultiValueMap();
            formData.add((Object)"username", (Object)this.username);
            formData.add((Object)"password", (Object)this.password);
            formData.add((Object)"client_id", (Object)this.clientId);
            formData.add((Object)"grant_type", (Object)this.grantType);
            KeycloakTokenResponse response = (KeycloakTokenResponse)((RestClient.RequestBodySpec)this.restClient.post().uri(this.loginUrl, new Object[0])).contentType(MediaType.APPLICATION_FORM_URLENCODED).body((Object)formData).retrieve().toEntity(KeycloakTokenResponse.class).getBody();
            if (response != null && response.getAccessToken() != null) {
                log.info("\u2705 Autenticaci\u00f3n exitosa con BackAgrota en: {}", (Object)this.loginUrl);
                this.cachedToken = response.getAccessToken();
                long expiresInSeconds = response.getExpiresIn() != null ? response.getExpiresIn() : 300L;
                this.expirationTime = System.currentTimeMillis() + (expiresInSeconds - 30L) * 1000L;
                return this.cachedToken;
            }
            log.warn("\u26a0\ufe0f Autenticaci\u00f3n fallida con BackAgrota en: {} (Respuesta vac\u00eda o sin token)", (Object)this.loginUrl);
        }
        catch (Exception e) {
            log.error("\u274c Error conectando con el servicio de autenticaci\u00f3n en {}: {}", (Object)this.loginUrl, (Object)e.getMessage());
            throw e;
        }
        return null;
    }

    public synchronized String fallbackGetAccessToken(boolean forceRefresh, Throwable t) {
        log.error("\ud83d\udea8 Circuit Breaker fallback para getAccessToken en {}: {}", (Object)this.loginUrl, (Object)t.getMessage());
        throw new RuntimeException("No se pudo obtener el token de acceso debido a una falla en el circuito: " + t.getMessage());
    }

    @Generated
    public KeycloakService(RestClient restClient) {
        this.restClient = restClient;
    }
}

