/*
 * Decompiled with CFR 0.152.
 */
package agrota.mcpserveragrota.service;

import agrota.mcpserveragrota.model.dto.PowerBIQuery;
import agrota.mcpserveragrota.model.dto.PowerBIQueryRequest;
import agrota.mcpserveragrota.model.dto.PowerBIQueryResponse;
import agrota.mcpserveragrota.service.KeycloakService;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClient;

@Service
public class BackAgrotaClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BackAgrotaClient.class);
    private final RestClient restClient;
    private final KeycloakService keycloakService;
    @Value(value="${back-agrota.url}")
    private String backAgrotaUrl;

    public PowerBIQueryResponse sendQuery(String sqlQuery) {
        String token = this.keycloakService.getAccessToken();
        PowerBIQueryRequest request = new PowerBIQueryRequest(List.of(new PowerBIQuery(sqlQuery)));
        try {
            return this.executeRequest(request, token);
        }
        catch (HttpClientErrorException.Unauthorized e) {
            token = this.keycloakService.getAccessToken(true);
            return this.executeRequest(request, token);
        }
    }

    private PowerBIQueryResponse executeRequest(PowerBIQueryRequest request, String token) {
        try {
            PowerBIQueryResponse response = (PowerBIQueryResponse)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().uri(this.backAgrotaUrl, new Object[0])).header("Authorization", new String[]{"Bearer " + token})).contentType(MediaType.APPLICATION_JSON).body((Object)request).retrieve().body(PowerBIQueryResponse.class);
            log.info("\u2705 Consulta enviada exitosamente a BackAgrota en: {}", (Object)this.backAgrotaUrl);
            return response;
        }
        catch (Exception e) {
            log.error("\u274c Error enviando consulta a BackAgrota en {}: {}", (Object)this.backAgrotaUrl, (Object)e.getMessage());
            throw e;
        }
    }

    @Generated
    public BackAgrotaClient(RestClient restClient, KeycloakService keycloakService) {
        this.restClient = restClient;
        this.keycloakService = keycloakService;
    }
}

