/*
 * Decompiled with CFR 0.152.
 */
package agrota.mcpserveragrota.controller;

import agrota.mcpserveragrota.tool.AgrotaMcpTools;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class McpHttpController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(McpHttpController.class);
    private final AgrotaMcpTools agrotaMcpTools;

    @PostMapping(value={"/mcp"})
    public ResponseEntity<Map<String, String>> consultarAgrota(@RequestBody Map<String, String> request) {
        log.info("\ud83d\udce5 Solicitud HTTP MCP recibida");
        String prompt = request.get("prompt");
        if (prompt == null || prompt.trim().isEmpty()) {
            log.error("\u274c Prompt vac\u00edo o nulo");
            return ResponseEntity.badRequest().body(Map.of("error", "El campo 'prompt' es requerido"));
        }
        try {
            String result = this.agrotaMcpTools.consultarAgrota(prompt);
            log.info("\u2705 Respuesta generada exitosamente");
            return ResponseEntity.ok(Map.of("result", result));
        }
        catch (Exception e) {
            log.error("\u274c Error procesando solicitud", (Throwable)e);
            return ResponseEntity.internalServerError().body(Map.of("error", "Error procesando la solicitud: " + e.getMessage()));
        }
    }

    @Generated
    public McpHttpController(AgrotaMcpTools agrotaMcpTools) {
        this.agrotaMcpTools = agrotaMcpTools;
    }
}

