/*
 * Decompiled with CFR 0.152.
 */
package agrota.mcpserveragrota.controller;

import agrota.mcpserveragrota.tool.AgrotaMcpTools;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/bridge"})
public class McpBridgeController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(McpBridgeController.class);
    private final AgrotaMcpTools agrotaMcpTools;
    @Value(value="${auth.whatsapp.whitelist:}")
    private String whitelist;

    @PostMapping(value={"/message"})
    public ResponseEntity<Map<String, Object>> handleWhatsAppMessage(@RequestBody Map<String, Object> payload) {
        log.info("\ud83c\udf09 Bridge Controller recibi\u00f3 mensaje");
        String from = this.extractFromNumber(payload);
        if (!this.isWhitelisted(from)) {
            log.warn("\ud83d\udeab Acceso denegado para el n\u00famero: {}", (Object)from);
            return ResponseEntity.ok((Object)this.createTextResponse("Acceso denegado"));
        }
        String userMessage = this.extractMessageBody(payload);
        if (userMessage == null) {
            log.warn("Payload no compatible o mensaje vac\u00edo. Puenteando a 'prompt' si existe.");
            if (payload.containsKey("prompt")) {
                userMessage = (String)payload.get("prompt");
            } else if (payload.containsKey("message")) {
                userMessage = (String)payload.get("message");
            }
        }
        if (userMessage == null) {
            log.error("No se pudo extraer el mensaje del payload");
            return ResponseEntity.badRequest().body(Map.of("error", "Invalid payload format. Expected { 'text': { 'body': '...' } } or { 'prompt': '...' } or { 'message': '...' }"));
        }
        String userName = "";
        String userPosition = "";
        if (payload.containsKey("context") && payload.get("context") instanceof Map) {
            Map context = (Map)payload.get("context");
            userName = context.getOrDefault("userName", "");
            userPosition = context.getOrDefault("userPosition", "");
        }
        String responseText = this.agrotaMcpTools.consultarAgrota(userMessage, userName, userPosition);
        return ResponseEntity.ok((Object)this.createTextResponse(responseText));
    }

    private boolean isWhitelisted(String from) {
        if (this.whitelist == null || this.whitelist.trim().isEmpty()) {
            return true;
        }
        List<String> whitelistedNumbers = Arrays.asList(this.whitelist.split(","));
        return from != null && whitelistedNumbers.contains(from.trim());
    }

    private String extractFromNumber(Map<String, Object> payload) {
        if (payload.containsKey("from")) {
            return String.valueOf(payload.get("from"));
        }
        return null;
    }

    private Map<String, Object> createTextResponse(String text) {
        Map<String, String> textBody = Map.of("body", text);
        Map<String, Map<String, String>> reply = Map.of("type", "text", "text", textBody);
        return Map.of("status", "success", "replies", List.of(reply));
    }

    private String extractMessageBody(Map<String, Object> payload) {
        try {
            if (payload.containsKey("text") && payload.get("text") instanceof Map) {
                Map textNode = (Map)payload.get("text");
                return (String)textNode.get("body");
            }
        }
        catch (Exception e) {
            log.error("Error parsing payload", (Throwable)e);
        }
        return null;
    }

    @Generated
    public McpBridgeController(AgrotaMcpTools agrotaMcpTools) {
        this.agrotaMcpTools = agrotaMcpTools;
    }
}

