/*
 * Decompiled with CFR 0.152.
 */
package agrota.mcpserveragrota.config;

import java.util.List;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class ToolDiagnosticRunner
implements CommandLineRunner {
    private final ApplicationContext ctx;

    public ToolDiagnosticRunner(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    public void run(String ... args) throws Exception {
        System.out.println("--- TOOL DIAGNOSTIC ---");
        System.out.println("1. Checking for ToolCallback beans...");
        try {
            String[] callbackBeans;
            for (String cb : callbackBeans = this.ctx.getBeanNamesForType(ToolCallback.class)) {
                ToolCallback bean = (ToolCallback)this.ctx.getBean(cb, ToolCallback.class);
                System.out.println("ToolCallback Bean: " + cb + " [Tool Name: " + bean.getToolDefinition().name() + "]");
            }
        }
        catch (Exception e) {
            System.out.println("Error getting ToolCallback beans: " + e.getMessage());
        }
        System.out.println("\n2. Checking for 'syncTools' bean content...");
        try {
            if (this.ctx.containsBean("syncTools")) {
                Object syncTools = this.ctx.getBean("syncTools");
                System.out.println("syncTools Bean Type: " + syncTools.getClass().getName());
                if (syncTools instanceof List) {
                    List list = (List)syncTools;
                    System.out.println("syncTools List size: " + list.size());
                    for (Object item : list) {
                        System.out.println(" - Item: " + item.getClass().getName() + " -> " + item.toString());
                    }
                }
            } else {
                System.out.println("'syncTools' bean not found.");
            }
        }
        catch (Exception e) {
            System.out.println("Error checking 'syncTools': " + e.getMessage());
        }
        System.out.println("\n3. Checking for AgrotaMcpTools bean...");
        try {
            if (this.ctx.containsBean("agrotaMcpTools")) {
                Object bean = this.ctx.getBean("agrotaMcpTools");
                System.out.println("agrotaMcpTools Bean found. Class: " + bean.getClass().getName());
            } else {
                System.out.println("agrotaMcpTools bean NOT found.");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("\n--- END TOOL DIAGNOSTIC ---");
    }
}

