/*
 * Decompiled with CFR 0.152.
 */
package agrota.backagrota.logic.method.service.impl;

import agrota.backagrota.logic.lhia.service.PowerBIQueryLogService;
import agrota.backagrota.logic.method.model.PowerBIQuery;
import agrota.backagrota.logic.method.model.PowerBIQueryRequest;
import agrota.backagrota.logic.method.model.PowerBIQueryResponse;
import agrota.backagrota.logic.method.service.MicrosoftAuthService;
import agrota.backagrota.logic.method.service.PowerBIService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class PowerBIServiceImpl
implements PowerBIService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PowerBIServiceImpl.class);
    private final MicrosoftAuthService microsoftAuthService;
    private final WebClient.Builder webClientBuilder;
    private final Environment env;
    private final PowerBIQueryLogService powerBiQueryLogService;

    public PowerBIQueryResponse executeQuery(PowerBIQueryRequest request) {
        log.info("Executing real PowerBI query: {}", (Object)request);
        String daxQuery = request.getQueries() != null && !request.getQueries().isEmpty() ? ((PowerBIQuery)request.getQueries().get(0)).getQuery() : "UNKNOWN";
        try {
            Map firstResult;
            List tables;
            List results;
            String token = (String)this.microsoftAuthService.getToken().block();
            if (token == null) {
                return PowerBIQueryResponse.builder().status("error").error("Failed to obtain Microsoft token").build();
            }
            String powerBiUrl = this.env.getProperty("powerbi.api.url");
            Map pbiResponse = (Map)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClientBuilder.build().post().uri(powerBiUrl, new Object[0])).header("Authorization", new String[]{"Bearer " + token})).contentType(MediaType.APPLICATION_JSON).bodyValue((Object)request).retrieve().onStatus(status -> !status.is2xxSuccessful(), clientResponse -> clientResponse.bodyToMono(String.class).flatMap(errorBody -> {
                log.error("\u274c PowerBI API Error {}: {}", (Object)clientResponse.statusCode(), errorBody);
                return Mono.error((Throwable)new RuntimeException("PowerBI API Error: " + errorBody));
            })).bodyToMono(Map.class).block();
            log.info("PowerBI API response: {}", (Object)pbiResponse);
            if (pbiResponse != null && pbiResponse.containsKey("results") && !(results = (List)pbiResponse.get("results")).isEmpty() && (tables = (List)(firstResult = (Map)results.get(0)).get("tables")) != null && !tables.isEmpty()) {
                List rows = (List)((Map)tables.get(0)).get("rows");
                this.powerBiQueryLogService.saveLog(daxQuery, "SUCCESS", null);
                return PowerBIQueryResponse.builder().status("success").results(rows).build();
            }
            this.powerBiQueryLogService.saveLog(daxQuery, "SUCCESS", null);
            return PowerBIQueryResponse.builder().status("success").results(Collections.emptyList()).build();
        }
        catch (Exception e) {
            log.error("Error executing PowerBI query", (Throwable)e);
            this.powerBiQueryLogService.saveLog(daxQuery, "ERROR", e.getMessage());
            return PowerBIQueryResponse.builder().status("error").error(e.getMessage()).build();
        }
    }

    @Generated
    public PowerBIServiceImpl(MicrosoftAuthService microsoftAuthService, WebClient.Builder webClientBuilder, Environment env, PowerBIQueryLogService powerBiQueryLogService) {
        this.microsoftAuthService = microsoftAuthService;
        this.webClientBuilder = webClientBuilder;
        this.env = env;
        this.powerBiQueryLogService = powerBiQueryLogService;
    }
}

